/*
 * Decompiled with CFR 0.152.
 */
package org.hazlewood.connor.bottema.emailaddress;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.hazlewood.connor.bottema.emailaddress.EmailAddressCriteria;

final class Dragons {
    public final Pattern MAILBOX_PATTERN;
    public final Pattern ADDR_SPEC_PATTERN;
    public final Pattern MAILBOX_LIST_PATTERN;
    public final Pattern ADDRESS_PATTERN;
    public final Pattern COMMENT_PATTERN;
    public final Pattern QUOTED_STRING_WO_CFWS_PATTERN;
    public final Pattern RETURN_PATH_PATTERN;
    public final Pattern GROUP_PREFIX_PATTERN;
    public final Pattern ESCAPED_QUOTE_PATTERN;
    public final Pattern ESCAPED_BSLASH_PATTERN;
    private static final Map<EnumSet<EmailAddressCriteria>, Dragons> cache = new HashMap<EnumSet<EmailAddressCriteria>, Dragons>();

    protected static Dragons fromCriteria(EnumSet<EmailAddressCriteria> criteria) {
        if (!cache.containsKey(criteria)) {
            cache.put(criteria, new Dragons(criteria));
        }
        return cache.get(criteria);
    }

    private Dragons(EnumSet<EmailAddressCriteria> criteria) {
        String crlf = "\\r\\n";
        String wsp = "[ \\t]";
        String fwsp = "(?:[ \\t]*\\r\\n)?[ \\t]+";
        String dquote = "\\\"";
        String noWsCtl = "\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F";
        String asciiText = "[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]";
        String quotedPair = "(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F])";
        String ctext = "[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]";
        String ccontent = "[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F])";
        String comment = "\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\)";
        String cfws = "(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))*(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))|(?:(?:[ \\t]*\\r\\n)?[ \\t]+))";
        String atext = "[a-zA-Z0-9\\!\\#-\\'\\*\\+\\-\\/\\=\\?\\^-\\`\\{-\\~" + (criteria.contains((Object)EmailAddressCriteria.ALLOW_DOT_IN_A_TEXT) ? "\\." : "") + (criteria.contains((Object)EmailAddressCriteria.ALLOW_SQUARE_BRACKETS_IN_A_TEXT) ? "\\[\\]" : "") + "]";
        String regularAtext = "[a-zA-Z0-9\\!\\#-\\'\\*\\+\\-\\/\\=\\?\\^-\\`\\{-\\~]";
        String atom = "(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))*(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))|(?:(?:[ \\t]*\\r\\n)?[ \\t]+)))?" + atext + "+(?:" + "(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))*(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))|(?:(?:[ \\t]*\\r\\n)?[ \\t]+))" + ")?";
        String dotAtomText = "[a-zA-Z0-9\\!\\#-\\'\\*\\+\\-\\/\\=\\?\\^-\\`\\{-\\~]+(?:\\.[a-zA-Z0-9\\!\\#-\\'\\*\\+\\-\\/\\=\\?\\^-\\`\\{-\\~]+)*";
        String capDotAtomNoCFWS = "(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))*(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))|(?:(?:[ \\t]*\\r\\n)?[ \\t]+)))?([a-zA-Z0-9\\!\\#-\\'\\*\\+\\-\\/\\=\\?\\^-\\`\\{-\\~]+(?:\\.[a-zA-Z0-9\\!\\#-\\'\\*\\+\\-\\/\\=\\?\\^-\\`\\{-\\~]+)*)(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))*(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))|(?:(?:[ \\t]*\\r\\n)?[ \\t]+)))?";
        String capDotAtomTrailingCFWS = "(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))*(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))|(?:(?:[ \\t]*\\r\\n)?[ \\t]+)))?([a-zA-Z0-9\\!\\#-\\'\\*\\+\\-\\/\\=\\?\\^-\\`\\{-\\~]+(?:\\.[a-zA-Z0-9\\!\\#-\\'\\*\\+\\-\\/\\=\\?\\^-\\`\\{-\\~]+)*)((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))*(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))|(?:(?:[ \\t]*\\r\\n)?[ \\t]+)))?";
        String qtext = "[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!\\#-\\[\\]-\\~]";
        String localPartqtext = "[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F" + (criteria.contains((Object)EmailAddressCriteria.ALLOW_PARENS_IN_LOCALPART) ? "\\!\\#-\\[\\]-\\~]" : "\\!\\#-\\'\\*-\\[\\]-\\~]");
        String qcontent = "(?:[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!\\#-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))";
        String localPartqcontent = "(?>" + localPartqtext + "|" + "(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F])" + ")";
        String quotedStringWOCFWS = "\\\"(?>(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?(?:[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!\\#-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F])))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\\"";
        String quotedString = "(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))*(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))|(?:(?:[ \\t]*\\r\\n)?[ \\t]+)))?\\\"(?>(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?(?:[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!\\#-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F])))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\\"(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))*(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))|(?:(?:[ \\t]*\\r\\n)?[ \\t]+)))?";
        String localPartQuotedString = "(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))*(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))|(?:(?:[ \\t]*\\r\\n)?[ \\t]+)))?(\\\"(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?" + localPartqcontent + ")*(?:" + "(?:[ \\t]*\\r\\n)?[ \\t]+" + ")?" + "\\\"" + ")(?:" + "(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))*(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))|(?:(?:[ \\t]*\\r\\n)?[ \\t]+))" + ")?";
        String word = "(?:(?:" + atom + ")|(?:" + "(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))*(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))|(?:(?:[ \\t]*\\r\\n)?[ \\t]+)))?\\\"(?>(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?(?:[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!\\#-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F])))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\\"(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))*(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))|(?:(?:[ \\t]*\\r\\n)?[ \\t]+)))?" + "))";
        String phrase = word + "(?:(?:" + "(?:[ \\t]*\\r\\n)?[ \\t]+" + ")" + word + ")*";
        String letter = "[a-zA-Z]";
        String letDig = "[a-zA-Z0-9]";
        String letDigHyp = "[a-zA-Z0-9-]";
        String rfcLabel = "[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?";
        String rfc1035DomainName = "[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?(?:\\.[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?)*\\.[a-zA-Z]{2,6}";
        String dtext = "[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-Z\\^-\\~]";
        String dcontent = "[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-Z\\^-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F])";
        String capDomainLiteralNoCFWS = "(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))*(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))|(?:(?:[ \\t]*\\r\\n)?[ \\t]+)))?(\\[(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?(?:[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-Z\\^-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))+)*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\])(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))*(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))|(?:(?:[ \\t]*\\r\\n)?[ \\t]+)))?";
        String capDomainLiteralTrailingCFWS = "(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))*(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))|(?:(?:[ \\t]*\\r\\n)?[ \\t]+)))?(\\[(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?(?:[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-Z\\^-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))+)*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\])((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))*(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))|(?:(?:[ \\t]*\\r\\n)?[ \\t]+)))?";
        String rfc2822Domain = "(?:(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))*(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))|(?:(?:[ \\t]*\\r\\n)?[ \\t]+)))?([a-zA-Z0-9\\!\\#-\\'\\*\\+\\-\\/\\=\\?\\^-\\`\\{-\\~]+(?:\\.[a-zA-Z0-9\\!\\#-\\'\\*\\+\\-\\/\\=\\?\\^-\\`\\{-\\~]+)*)(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))*(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))|(?:(?:[ \\t]*\\r\\n)?[ \\t]+)))?|(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))*(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))|(?:(?:[ \\t]*\\r\\n)?[ \\t]+)))?(\\[(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?(?:[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-Z\\^-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))+)*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\])(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))*(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))|(?:(?:[ \\t]*\\r\\n)?[ \\t]+)))?)";
        String capCFWSRfc2822Domain = "(?:(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))*(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))|(?:(?:[ \\t]*\\r\\n)?[ \\t]+)))?([a-zA-Z0-9\\!\\#-\\'\\*\\+\\-\\/\\=\\?\\^-\\`\\{-\\~]+(?:\\.[a-zA-Z0-9\\!\\#-\\'\\*\\+\\-\\/\\=\\?\\^-\\`\\{-\\~]+)*)((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))*(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))|(?:(?:[ \\t]*\\r\\n)?[ \\t]+)))?|(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))*(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))|(?:(?:[ \\t]*\\r\\n)?[ \\t]+)))?(\\[(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?(?:[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-Z\\^-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))+)*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\])((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))*(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))|(?:(?:[ \\t]*\\r\\n)?[ \\t]+)))?)";
        String domain = criteria.contains((Object)EmailAddressCriteria.ALLOW_DOMAIN_LITERALS) ? "(?:(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))*(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))|(?:(?:[ \\t]*\\r\\n)?[ \\t]+)))?([a-zA-Z0-9\\!\\#-\\'\\*\\+\\-\\/\\=\\?\\^-\\`\\{-\\~]+(?:\\.[a-zA-Z0-9\\!\\#-\\'\\*\\+\\-\\/\\=\\?\\^-\\`\\{-\\~]+)*)(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))*(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))|(?:(?:[ \\t]*\\r\\n)?[ \\t]+)))?|(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))*(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))|(?:(?:[ \\t]*\\r\\n)?[ \\t]+)))?(\\[(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?(?:[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-Z\\^-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))+)*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\])(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))*(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))|(?:(?:[ \\t]*\\r\\n)?[ \\t]+)))?)" : "(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))*(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))|(?:(?:[ \\t]*\\r\\n)?[ \\t]+)))?([a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?(?:\\.[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?)*\\.[a-zA-Z]{2,6})(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))*(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))|(?:(?:[ \\t]*\\r\\n)?[ \\t]+)))?";
        String capCFWSDomain = criteria.contains((Object)EmailAddressCriteria.ALLOW_DOMAIN_LITERALS) ? "(?:(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))*(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))|(?:(?:[ \\t]*\\r\\n)?[ \\t]+)))?([a-zA-Z0-9\\!\\#-\\'\\*\\+\\-\\/\\=\\?\\^-\\`\\{-\\~]+(?:\\.[a-zA-Z0-9\\!\\#-\\'\\*\\+\\-\\/\\=\\?\\^-\\`\\{-\\~]+)*)((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))*(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))|(?:(?:[ \\t]*\\r\\n)?[ \\t]+)))?|(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))*(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))|(?:(?:[ \\t]*\\r\\n)?[ \\t]+)))?(\\[(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?(?:[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-Z\\^-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))+)*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\])((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))*(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))|(?:(?:[ \\t]*\\r\\n)?[ \\t]+)))?)" : "(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))*(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))|(?:(?:[ \\t]*\\r\\n)?[ \\t]+)))?([a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?(?:\\.[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?)*\\.[a-zA-Z]{2,6})((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))*(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))|(?:(?:[ \\t]*\\r\\n)?[ \\t]+)))?";
        String localPart = "((?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))*(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))|(?:(?:[ \\t]*\\r\\n)?[ \\t]+)))?([a-zA-Z0-9\\!\\#-\\'\\*\\+\\-\\/\\=\\?\\^-\\`\\{-\\~]+(?:\\.[a-zA-Z0-9\\!\\#-\\'\\*\\+\\-\\/\\=\\?\\^-\\`\\{-\\~]+)*)(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))*(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))|(?:(?:[ \\t]*\\r\\n)?[ \\t]+)))?|" + localPartQuotedString + ")";
        String addrSpec = localPart + "@" + domain;
        String uniqueAddrSpec = localPart + "@" + capCFWSDomain;
        String angleAddr = "(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))*(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))|(?:(?:[ \\t]*\\r\\n)?[ \\t]+)))?<" + addrSpec + ">(" + "(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))*(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))|(?:(?:[ \\t]*\\r\\n)?[ \\t]+))" + ")?";
        String nameAddr = "(" + phrase + ")??(" + angleAddr + ")";
        String mailbox = (criteria.contains((Object)EmailAddressCriteria.ALLOW_QUOTED_IDENTIFIERS) ? "(" + nameAddr + ")|" : "") + "(" + uniqueAddrSpec + ")";
        String returnPath = "(?:(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))*(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))|(?:(?:[ \\t]*\\r\\n)?[ \\t]+)))?<((?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))*(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))|(?:(?:[ \\t]*\\r\\n)?[ \\t]+)))?|" + addrSpec + ")>(?:" + "(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))*(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))|(?:(?:[ \\t]*\\r\\n)?[ \\t]+))" + ")?)";
        String mailboxList = "(?:(?:" + mailbox + ")(?:,(?:" + mailbox + "))*)";
        String groupPostfix = "(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))*(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))|(?:(?:[ \\t]*\\r\\n)?[ \\t]+))|(?:" + mailboxList + "))?;(?:" + "(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))*(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))|(?:(?:[ \\t]*\\r\\n)?[ \\t]+))" + ")?";
        String groupPrefix = phrase + ":";
        String group = groupPrefix + groupPostfix;
        String address = "(?:(?:" + mailbox + ")|(?:" + group + "))";
        this.MAILBOX_PATTERN = Pattern.compile(mailbox);
        this.ADDR_SPEC_PATTERN = Pattern.compile(addrSpec);
        this.MAILBOX_LIST_PATTERN = Pattern.compile(mailboxList);
        this.ADDRESS_PATTERN = Pattern.compile(address);
        this.COMMENT_PATTERN = Pattern.compile("\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\)");
        this.QUOTED_STRING_WO_CFWS_PATTERN = Pattern.compile("\\\"(?>(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?(?:[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!\\#-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F])))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\\"");
        this.RETURN_PATH_PATTERN = Pattern.compile(returnPath);
        this.GROUP_PREFIX_PATTERN = Pattern.compile(groupPrefix);
        this.ESCAPED_QUOTE_PATTERN = Pattern.compile("\\\\\"");
        this.ESCAPED_BSLASH_PATTERN = Pattern.compile("\\\\\\\\");
    }
}

