/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.hibernate.access;

import com.hazelcast.core.HazelcastException;
import com.hazelcast.hibernate.access.AbstractAccessDelegate;
import com.hazelcast.hibernate.region.HazelcastRegion;
import java.util.Properties;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.access.SoftLock;

public class ReadWriteAccessDelegate<T extends HazelcastRegion>
extends AbstractAccessDelegate<T> {
    public ReadWriteAccessDelegate(T hazelcastRegion, Properties props) {
        super(hazelcastRegion, props);
    }

    @Override
    public boolean afterInsert(Object key, Object value, Object version) throws CacheException {
        try {
            return this.cache.insert(key, value, version);
        }
        catch (HazelcastException e) {
            if (this.log.isFinestEnabled()) {
                this.log.finest("Could not insert into Cache[" + this.hazelcastRegion.getName() + "]: " + e.getMessage());
            }
            return false;
        }
    }

    @Override
    public boolean afterUpdate(Object key, Object value, Object currentVersion, Object previousVersion, SoftLock lock) throws CacheException {
        try {
            return this.cache.update(key, value, currentVersion, lock);
        }
        catch (HazelcastException e) {
            if (this.log.isFinestEnabled()) {
                this.log.finest("Could not update Cache[" + this.hazelcastRegion.getName() + "]: " + e.getMessage());
            }
            return false;
        }
    }

    @Override
    public boolean insert(Object key, Object value, Object version) throws CacheException {
        return false;
    }

    @Override
    public SoftLock lockItem(Object key, Object version) throws CacheException {
        return this.cache.tryLock(key, version);
    }

    @Override
    public void unlockItem(Object key, SoftLock lock) throws CacheException {
        this.cache.unlock(key, lock);
    }

    @Override
    public boolean update(Object key, Object value, Object currentVersion, Object previousVersion) throws CacheException {
        return false;
    }

    @Override
    public void remove(Object key) throws CacheException {
    }

    @Override
    public void removeAll() throws CacheException {
    }
}

