/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.ssl.rmi;

import java.net.MalformedURLException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.server.RMISocketFactory;
import org.apache.commons.ssl.LogWrapper;
import org.apache.commons.ssl.RMISocketFactoryImpl;
import org.apache.commons.ssl.rmi.DateRMI;
import org.apache.commons.ssl.rmi.IntegerRMI;
import org.apache.commons.ssl.rmi.RemoteDate;
import org.apache.commons.ssl.rmi.RemoteInteger;

public class Test {
    private static final LogWrapper log = LogWrapper.getLogger(Test.class);
    private static final String TEST_DATE_NAME = "/org.apache.commons.ssl.rmi.testdate";
    private static final String TEST_INT_NAME = "/org.apache.commons.ssl.rmi.testint";
    protected static final int PORT;
    protected static final String URL;
    private static boolean rmiRunning;

    public static Object lookup(String ref) throws RemoteException, NotBoundException, MalformedURLException {
        return Naming.lookup(URL + ref);
    }

    public static void rebind(String ref, Remote obj) throws RemoteException, MalformedURLException {
        Test.requireNameServer();
        String realRef = URL + ref;
        Naming.rebind(realRef, obj);
        try {
            Object o = Test.lookup(ref);
            log.debug("Bound " + o.getClass().getName() + " to [" + realRef + "]");
        }
        catch (NotBoundException nbe) {
            log.debug("Error binding " + obj.getClass().getName() + " to [" + realRef + "]");
        }
    }

    private static void rebindTest() throws Exception {
        DateRMI remoteTest = new DateRMI();
        Naming.rebind(URL + TEST_DATE_NAME, remoteTest);
        Remote o = Naming.lookup(URL + TEST_DATE_NAME);
        if (!((Object)remoteTest).equals(o)) {
            throw new RuntimeException("rmi: Test failed. Lookup != Rebind");
        }
    }

    private static synchronized void requireNameServer() {
        if (rmiRunning) {
            return;
        }
        try {
            Test.rebindTest();
            rmiRunning = true;
        }
        catch (Exception e) {
            Test.tryToStartNameServer();
            try {
                Test.rebindTest();
                log.debug(Test.class.getName() + " successfully started.");
                rmiRunning = true;
                return;
            }
            catch (Exception e2) {
                e2.printStackTrace();
                log.error(e2.getMessage(), e2);
                String msg = Test.class.getName() + " cannot start.";
                log.error(msg);
                throw new RuntimeException(msg);
            }
        }
    }

    public static void tryToStartNameServer() {
        String className = Test.class.getName();
        log.debug(className + " probably not running.   Trying to start one.");
        try {
            LocateRegistry.createRegistry(PORT);
            log.debug("registry on " + PORT + " started!");
        }
        catch (Exception problem) {
            problem.printStackTrace();
            log.warn(problem, problem);
        }
    }

    public static void main(String[] args) throws Exception {
        System.setProperty("java.rmi.server.hostname", "localhost");
        RMISocketFactoryImpl impl = new RMISocketFactoryImpl();
        RMISocketFactory.setSocketFactory(impl);
        if (args.length <= 0) {
            Test.requireNameServer();
            Test.rebindTest();
            IntegerRMI remoteInt = new IntegerRMI();
            Test.rebind(TEST_INT_NAME, remoteInt);
        }
        Object o = Test.lookup(TEST_DATE_NAME);
        RemoteDate rd = (RemoteDate)o;
        System.out.println("The remote-date is: " + rd.getDate());
        o = Test.lookup(TEST_INT_NAME);
        RemoteInteger ri = (RemoteInteger)o;
        System.out.println("The remote-int  is: " + ri.getInt());
    }

    static {
        rmiRunning = false;
        int port = 1099;
        String host = "127.0.0.1";
        PORT = port;
        URL = "rmi://" + host + ":" + port;
    }
}

