/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.logback.extensions.logstash;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.ThrowableProxyUtil;
import ch.qos.logback.core.encoder.EncoderBase;
import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.status.Status;
import com.google.gson.JsonObject;
import com.openexchange.logback.extensions.logstash.CustomField;
import com.openexchange.logback.extensions.logstash.LogstashFieldName;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.time.FastDateFormat;

public class LogstashEncoder
extends EncoderBase<ILoggingEvent> {
    public static final FastDateFormat LOGSTASH_TIMEFORMAT = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ss.SSSZZ");
    private final List<CustomField> customFields = new ArrayList<CustomField>();

    public void addCustomField(CustomField customField) {
        this.customFields.add(customField);
    }

    public byte[] headerBytes() {
        return null;
    }

    public byte[] encode(ILoggingEvent event) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            JsonObject j = new JsonObject();
            j.addProperty(LogstashFieldName.timestamp.getLogstashName(), LOGSTASH_TIMEFORMAT.format(event.getTimeStamp()));
            j.addProperty(LogstashFieldName.version.getLogstashName(), (Number)1);
            j.addProperty(LogstashFieldName.level.getLogstashName(), event.getLevel().levelStr);
            j.addProperty(LogstashFieldName.logger.getLogstashName(), event.getLoggerName());
            j.addProperty(LogstashFieldName.thread.getLogstashName(), event.getThreadName());
            j.addProperty(LogstashFieldName.message.getLogstashName(), event.getFormattedMessage());
            j.addProperty(LogstashFieldName.line.getLogstashName(), (Number)this.getLineNumber(event));
            j.addProperty(LogstashFieldName.clazz.getLogstashName(), this.getFullyQualifiedName(event));
            if (event.getMarker() != null) {
                j.addProperty(LogstashFieldName.marker.getLogstashName(), event.getMarker().getName());
            }
            if (event.getThrowableProxy() != null) {
                j.addProperty(LogstashFieldName.stacktrace.getLogstashName(), ThrowableProxyUtil.asString((IThrowableProxy)event.getThrowableProxy()));
            }
            Map mdc = event.getMDCPropertyMap();
            for (String key : mdc.keySet()) {
                j.addProperty(key, (String)mdc.get(key));
            }
            for (CustomField customField : this.customFields) {
                j.addProperty(customField.getKey(), customField.getValue());
            }
            IOUtils.write((String)IOUtils.LINE_SEPARATOR, (OutputStream)outputStream);
            outputStream.write(j.toString().getBytes());
        }
        catch (IOException e) {
            this.addStatus((Status)new ErrorStatus("An I/O error occurred during event encoding", (Object)this, (Throwable)e));
        }
        return outputStream.toByteArray();
    }

    public byte[] footerBytes() {
        return null;
    }

    private int getLineNumber(ILoggingEvent event) {
        StackTraceElement[] cda = event.getCallerData();
        if (cda != null && cda.length > 0) {
            return cda[0].getLineNumber();
        }
        return -1;
    }

    private String getFullyQualifiedName(ILoggingEvent event) {
        StackTraceElement[] cda = event.getCallerData();
        if (cda != null && cda.length > 0) {
            return cda[0].getClassName();
        }
        return "?";
    }
}

