/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.osgi.data;

import com.openexchange.osgi.data.AbstractDependency;
import com.openexchange.osgi.data.AbstractModule;
import com.openexchange.osgi.data.BinDirModule;
import com.openexchange.osgi.data.BundleImport;
import com.openexchange.osgi.data.JDK;
import com.openexchange.osgi.data.JarModule;
import com.openexchange.osgi.data.ModuleDependencies;
import com.openexchange.osgi.data.OSGIManifest;
import com.openexchange.osgi.data.RequiredBundle;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.GradleException;
import org.gradle.api.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001f\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u0011\"\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J\u0016\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\fJ\u0006\u0010\u0017\u001a\u00020\u0018J$\u0010\u0019\u001a\u00020\u000f2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u001a2\u0006\u0010\u001b\u001a\u00020\bH\u0002J\u0010\u0010\u001c\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0015\u001a\u00020\u0007J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0015\u001a\u00020\u0007J\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00070 J\u0006\u0010!\u001a\u00020\u0018J\u0012\u0010\"\u001a\u0004\u0018\u00010\b2\u0006\u0010#\u001a\u00020$H\u0002J\u0012\u0010%\u001a\u0004\u0018\u00010\b2\u0006\u0010&\u001a\u00020\u0007H\u0002J\u0012\u0010'\u001a\u0004\u0018\u00010\u00072\u0006\u0010&\u001a\u00020\u0007H\u0002J\u0012\u0010(\u001a\u0004\u0018\u00010\u00072\u0006\u0010#\u001a\u00020$H\u0002R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\n0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\f0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\n0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/openexchange/osgi/data/ModuleDatabase;", "", "logger", "Lorg/gradle/api/logging/Logger;", "(Lorg/gradle/api/logging/Logger;)V", "binaries", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/openexchange/osgi/data/AbstractModule;", "binariesExports", "Ljava/util/LinkedList;", "modules", "Lcom/openexchange/osgi/data/OSGIManifest;", "modulesExports", "addBinaryModules", "", "files", "", "Ljava/io/File;", "([Ljava/io/File;)V", "addModule", "moduleName", "manifest", "binariesSize", "", "duplicateModule", "", "module", "getModule", "getModuleDependencies", "Lcom/openexchange/osgi/data/ModuleDependencies;", "modulesIterator", "Ljava/util/Enumeration;", "modulesSize", "searchBinariesForBundle", "reqBundle", "Lcom/openexchange/osgi/data/RequiredBundle;", "searchBinariesForExport", "export", "searchModulesForExport", "searchProjectsForBundle", "osgi"})
public final class ModuleDatabase {
    private final ConcurrentHashMap<String, OSGIManifest> modules;
    private final ConcurrentHashMap<String, LinkedList<String>> modulesExports;
    private final ConcurrentHashMap<String, AbstractModule> binaries;
    private final ConcurrentHashMap<String, LinkedList<String>> binariesExports;
    private final Logger logger;

    public final int modulesSize() {
        return this.modules.size();
    }

    public final int binariesSize() {
        return this.binaries.size();
    }

    public final void addModule(@NotNull String moduleName, @NotNull OSGIManifest manifest) {
        Intrinsics.checkParameterIsNotNull((Object)moduleName, (String)"moduleName");
        Intrinsics.checkParameterIsNotNull((Object)manifest, (String)"manifest");
        Map map2 = this.modules;
        OSGIManifest oSGIManifest = manifest;
        map2.put(moduleName, oSGIManifest);
        for (String e : manifest.getExports()) {
            String string;
            LinkedList<String> linkedList = this.modulesExports.get(e);
            if (linkedList == null) {
                linkedList = new LinkedList<String>();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)linkedList, (String)"modulesExports[e] ?: LinkedList()");
            LinkedList<String> list = linkedList;
            if (!list.isEmpty()) {
                this.logger.warn(manifest.getEntry("Bundle-SymbolicName") + " exports " + e + " which is already registered and exported from " + list);
            }
            list.add(moduleName);
            Map map3 = this.modulesExports;
            Intrinsics.checkExpressionValueIsNotNull((Object)e, (String)"e");
            LinkedList<String> linkedList2 = list;
            map3.put(string, linkedList2);
        }
        this.logger.info("{}: Added: {} as bundle to the Module-Database", (Object)"OSGi-Plugin", (Object)moduleName);
    }

    @NotNull
    public final Enumeration<String> modulesIterator() {
        Enumeration<String> enumeration = this.modules.keys();
        Intrinsics.checkExpressionValueIsNotNull(enumeration, (String)"modules.keys()");
        return enumeration;
    }

    @Nullable
    public final OSGIManifest getModule(@NotNull String moduleName) {
        Intrinsics.checkParameterIsNotNull((Object)moduleName, (String)"moduleName");
        return this.modules.get(moduleName);
    }

    public final void addBinaryModules(File ... files) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)files, (String)"files");
        for (File file : files) {
            AbstractModule abstractModule;
            if (file.isFile()) {
                abstractModule = new JarModule(file);
            } else if (file.isDirectory()) {
                abstractModule = new BinDirModule(file);
            } else {
                throw (Throwable)new IOException("Don't know how to handle " + file.getAbsolutePath());
            }
            AbstractModule module = abstractModule;
            for (String exportedPackage : module.getExportedPackages()) {
                String string;
                LinkedList<String> linkedList = this.binariesExports.get(exportedPackage);
                if (linkedList == null) {
                    linkedList = new LinkedList<String>();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)linkedList, (String)"binariesExports[exportedPackage] ?: LinkedList()");
                LinkedList<String> list = linkedList;
                if (!list.isEmpty()) {
                    this.logger.warn(module.name + " exports binary " + exportedPackage + " which is already registered and exported from " + list);
                }
                list.add(module.name);
                Map map2 = this.binariesExports;
                Intrinsics.checkExpressionValueIsNotNull((Object)exportedPackage, (String)"exportedPackage");
                LinkedList<String> linkedList2 = list;
                map2.put(string, linkedList2);
            }
            if (this.binaries.put(module.name, module) == null) continue;
            this.duplicateModule((Map<String, ? extends AbstractModule>)this.binaries, module);
        }
        this.logger.info("{}: Added binary modules to the Module-Database", (Object)"OSGi-Plugin");
    }

    private final void duplicateModule(Map<String, ? extends AbstractModule> modules, AbstractModule module) throws IOException {
        String string;
        AbstractModule other = null;
        for (AbstractModule abstractModule : modules.values()) {
            if (!Intrinsics.areEqual((Object)abstractModule, (Object)module)) continue;
            other = abstractModule;
            break;
        }
        StringBuilder stringBuilder = new StringBuilder().append("Trying to add duplicate module ");
        File file = module.getFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"module.getFile()");
        StringBuilder stringBuilder2 = stringBuilder.append(file.getAbsolutePath()).append(". Other module is ");
        if (other != null) {
            File file2 = other.getFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"other.getFile()");
            string = file2.getAbsolutePath();
        } else {
            string = "unknown";
        }
        throw (Throwable)new IOException(stringBuilder2.append(string).append(".").toString());
    }

    @NotNull
    public final ModuleDependencies getModuleDependencies(@NotNull String moduleName) throws GradleException {
        Object it;
        Object object;
        OSGIManifest myManifest;
        Intrinsics.checkParameterIsNotNull((Object)moduleName, (String)"moduleName");
        OSGIManifest oSGIManifest = myManifest = this.modules.get(moduleName);
        if (oSGIManifest == null) {
            Intrinsics.throwNpe();
        }
        Set<BundleImport> myImports = oSGIManifest.getImports();
        ModuleDependencies myDependencies = new ModuleDependencies();
        Set<RequiredBundle> requiredBundles = myManifest.getRequiredBundles();
        Set<RequiredBundle> set = myManifest.getFragmentHost();
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"myManifest.fragmentHost");
        requiredBundles.addAll((Collection<RequiredBundle>)set);
        Iterator<AbstractDependency> iterator = requiredBundles.iterator();
        while (iterator.hasNext()) {
            boolean bl;
            boolean bl2;
            RequiredBundle reqBundle;
            RequiredBundle requiredBundle = reqBundle = iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)requiredBundle, (String)"reqBundle");
            if (Intrinsics.areEqual((Object)requiredBundle.getPackageName(), (Object)"system.bundle")) continue;
            it = object = this.searchProjectsForBundle(reqBundle);
            boolean bl3 = false;
            if (it == null) {
                bl2 = false;
            } else {
                myDependencies.addProject((String)it);
                bl2 = true;
            }
            if (bl2) continue;
            it = object = this.searchBinariesForBundle(reqBundle);
            boolean bl4 = false;
            if (it == null) {
                bl = false;
            } else {
                File file = ((AbstractModule)it).getFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"it.getFile()");
                myDependencies.addBinary(file);
                bl = true;
            }
            if (bl || reqBundle.isOptional()) continue;
            throw (Throwable)new GradleException("OSGi-Plugin: Could not find required Bundle: " + reqBundle.getPackageName() + " for: " + moduleName + " in Module-Database");
        }
        for (BundleImport myImport : myImports) {
            boolean bl;
            boolean bl5;
            Set<String> set2 = myManifest.getExports();
            BundleImport bundleImport = myImport;
            Intrinsics.checkExpressionValueIsNotNull((Object)bundleImport, (String)"myImport");
            if (set2.contains(bundleImport.getPackageName())) {
                this.logger.warn(moduleName + ": is importing and exporting the same Package!");
                continue;
            }
            if (JDK.exports(myImport.getPackageName())) continue;
            String string = myImport.getPackageName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"myImport.packageName");
            it = object = this.searchModulesForExport(string);
            boolean bl6 = false;
            if (it == null) {
                bl5 = false;
            } else {
                myDependencies.addProject((String)it);
                bl5 = true;
            }
            if (bl5) continue;
            String string2 = myImport.getPackageName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"myImport.packageName");
            it = object = this.searchBinariesForExport(string2);
            boolean bl7 = false;
            if (it == null) {
                bl = false;
            } else {
                File file = ((AbstractModule)it).getFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"it.getFile()");
                myDependencies.addBinary(file);
                bl = true;
            }
            if (bl || myImport.isOptional()) continue;
            throw (Throwable)new GradleException("OSGi-Plugin: Couldn't find required Export: " + myImport.getPackageName() + " for: " + moduleName + " in Module-Database ");
        }
        return myDependencies;
    }

    private final String searchProjectsForBundle(RequiredBundle reqBundle) {
        if (this.modules.containsKey(reqBundle.getPackageName())) {
            return reqBundle.getPackageName();
        }
        return null;
    }

    private final AbstractModule searchBinariesForBundle(RequiredBundle reqBundle) {
        Iterator<AbstractModule> iterator = this.binaries.values().iterator();
        while (iterator.hasNext()) {
            AbstractModule binary;
            AbstractModule abstractModule = binary = iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)abstractModule, (String)"binary");
            if (!Intrinsics.areEqual((Object)abstractModule.getSymbolicName(), (Object)reqBundle.getPackageName())) continue;
            return binary;
        }
        return null;
    }

    private final AbstractModule searchBinariesForExport(String export) {
        if (!this.binariesExports.containsKey(export)) {
            return null;
        }
        LinkedList<String> linkedList = this.binariesExports.get(export);
        if (linkedList == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull(linkedList, (String)"binariesExports[export] ?: return null");
        LinkedList<String> list = linkedList;
        return this.binaries.get(list.getFirst());
    }

    private final String searchModulesForExport(String export) {
        if (!this.modulesExports.containsKey(export)) {
            return null;
        }
        LinkedList<String> linkedList = this.modulesExports.get(export);
        if (linkedList == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull(linkedList, (String)"modulesExports[export] ?: return null");
        LinkedList<String> list = linkedList;
        return list.getFirst();
    }

    public ModuleDatabase(@NotNull Logger logger) {
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        this.logger = logger;
        this.modules = new ConcurrentHashMap();
        this.modulesExports = new ConcurrentHashMap();
        this.binaries = new ConcurrentHashMap();
        this.binariesExports = new ConcurrentHashMap();
    }
}

