/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.apns.internal;

import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;

public final class JWT {
    public static String getToken(String teamID, String keyID, String secret) throws InvalidKeySpecException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        int now = (int)(System.currentTimeMillis() / 1000L);
        String header = "{\"alg\":\"ES256\",\"kid\":\"" + keyID + "\"}";
        String payload = "{\"iss\":\"" + teamID + "\",\"iat\":" + now + "}";
        String part1 = Base64.getUrlEncoder().encodeToString(header.getBytes(StandardCharsets.UTF_8)) + "." + Base64.getUrlEncoder().encodeToString(payload.getBytes(StandardCharsets.UTF_8));
        return part1 + "." + JWT.ES256(secret, part1);
    }

    private static String ES256(String secret, String data) throws NoSuchAlgorithmException, InvalidKeySpecException, InvalidKeyException, SignatureException {
        KeyFactory kf = KeyFactory.getInstance("EC");
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(Base64.getDecoder().decode(secret.getBytes()));
        PrivateKey key = kf.generatePrivate(keySpec);
        Signature sha256withECDSA = Signature.getInstance("SHA256withECDSA");
        sha256withECDSA.initSign(key);
        sha256withECDSA.update(data.getBytes(StandardCharsets.UTF_8));
        byte[] signed = sha256withECDSA.sign();
        return Base64.getUrlEncoder().encodeToString(signed);
    }
}

