/*
 * Decompiled with CFR 0.152.
 */
package net.sf.uadetector.internal.data.domain;

import java.io.Serializable;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import net.sf.qualitycheck.Check;

@Immutable
public final class BrowserOperatingSystemMapping
implements Serializable {
    private static final long serialVersionUID = 6074931648810031757L;
    @Nonnegative
    private final int browserId;
    @Nonnegative
    private final int operatingSystemId;

    public BrowserOperatingSystemMapping(@Nonnegative int browserId, @Nonnegative int operatingSystemId) {
        Check.notNegative((int)browserId, (String)"browserId");
        Check.notNegative((int)operatingSystemId, (String)"operatingSystemId");
        this.browserId = browserId;
        this.operatingSystemId = operatingSystemId;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BrowserOperatingSystemMapping other = (BrowserOperatingSystemMapping)obj;
        if (this.browserId != other.browserId) {
            return false;
        }
        return this.operatingSystemId == other.operatingSystemId;
    }

    @Nonnegative
    public int getBrowserId() {
        return this.browserId;
    }

    @Nonnegative
    public int getOperatingSystemId() {
        return this.operatingSystemId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.browserId;
        result = 31 * result + this.operatingSystemId;
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("BrowserOperatingSystemMapping [browserId=");
        builder.append(this.browserId);
        builder.append(", operatingSystemId=");
        builder.append(this.operatingSystemId);
        builder.append("]");
        return builder.toString();
    }

    @NotThreadSafe
    public static final class Builder {
        private int browserId = Integer.MIN_VALUE;
        private int operatingSystemId = Integer.MIN_VALUE;

        @Nonnull
        public BrowserOperatingSystemMapping build() {
            return new BrowserOperatingSystemMapping(this.browserId, this.operatingSystemId);
        }

        public int getBrowserId() {
            return this.browserId;
        }

        public int getOperatingSystemId() {
            return this.operatingSystemId;
        }

        @Nonnull
        public Builder setBrowserId(@Nonnegative int browserId) {
            Check.notNegative((int)browserId, (String)"browserId");
            this.browserId = browserId;
            return this;
        }

        @Nonnull
        public Builder setBrowserId(@Nonnull String browserId) {
            Check.notNull((Object)browserId, (String)"browserId");
            this.setBrowserId(Integer.parseInt(browserId.trim()));
            return this;
        }

        @Nonnull
        public Builder setOperatingSystemId(@Nonnegative int operatingSystemId) {
            Check.notNegative((int)operatingSystemId, (String)"operatingSystemId");
            this.operatingSystemId = operatingSystemId;
            return this;
        }

        @Nonnull
        public Builder setOperatingSystemId(@Nonnull String operatingSystemId) {
            Check.notNull((Object)operatingSystemId, (String)"operatingSystemId");
            this.setOperatingSystemId(Integer.parseInt(operatingSystemId.trim()));
            return this;
        }
    }
}

