/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas;

import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.impl.LowLevelIterator;

public interface FSIterator<T extends FeatureStructure>
extends ListIterator<T> {
    public boolean isValid();

    default public T get() throws NoSuchElementException {
        if (!this.isValid()) {
            throw new NoSuchElementException();
        }
        return this.getNvc();
    }

    public T getNvc();

    default public void moveToNext() {
        if (!this.isValid()) {
            return;
        }
        this.moveToNextNvc();
    }

    public void moveToNextNvc();

    default public void moveToPrevious() {
        if (!this.isValid()) {
            return;
        }
        this.moveToPreviousNvc();
    }

    public void moveToPreviousNvc();

    public void moveToFirst();

    public void moveToLast();

    public void moveTo(FeatureStructure var1);

    public FSIterator<T> copy();

    default public Type getType() {
        return ((LowLevelIterator)this).ll_getIndex().getType();
    }

    @Override
    default public boolean hasNext() {
        return this.isValid();
    }

    @Override
    default public T next() {
        if (!this.isValid()) {
            throw new NoSuchElementException();
        }
        return this.nextNvc();
    }

    default public T nextNvc() {
        T result = this.getNvc();
        this.moveToNextNvc();
        return result;
    }

    @Override
    default public boolean hasPrevious() {
        return this.isValid();
    }

    @Override
    default public T previous() {
        if (!this.isValid()) {
            throw new NoSuchElementException();
        }
        return this.previousNvc();
    }

    default public T previousNvc() {
        this.moveToPreviousNvc();
        return this.getNvc();
    }

    @Override
    default public int nextIndex() {
        throw new UnsupportedOperationException();
    }

    @Override
    default public int previousIndex() {
        throw new UnsupportedOperationException();
    }

    @Override
    default public void set(T e) {
        throw new UnsupportedOperationException();
    }

    @Override
    default public void add(T e) {
        throw new UnsupportedOperationException();
    }

    default public Spliterator<T> spliterator() {
        return Spliterators.spliterator(this, (long)((LowLevelIterator)this).ll_indexSizeMaybeNotCurrent(), 16449);
    }

    default public Stream<T> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    @Override
    default public void remove() {
        ((LowLevelIterator)this).ll_remove();
    }
}

