/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.proxy;

import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import org.javasimon.proxy.Delegating;

public class DelegatingMethodInvocation<T>
implements Delegating<T>,
Runnable,
Callable<Object> {
    private final T delegate;
    private final Object proxy;
    private final Method method;
    private final Object[] args;

    public DelegatingMethodInvocation(T target, Object proxy, Method method, Object ... args) {
        this.delegate = target;
        this.proxy = proxy;
        this.method = method;
        this.args = args;
    }

    public Object[] getArgs() {
        return this.args;
    }

    public Method getMethod() {
        return this.method;
    }

    public Object getProxy() {
        return this.proxy;
    }

    @Override
    public T getDelegate() {
        return this.delegate;
    }

    public Method getTargetMethod() throws NoSuchMethodException {
        return this.delegate.getClass().getMethod(this.method.getName(), this.method.getParameterTypes());
    }

    public Object proceed() throws Throwable {
        return this.method.invoke(this.delegate, this.args);
    }

    @Override
    public void run() {
        try {
            this.proceed();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public Object call() throws Exception {
        try {
            return this.proceed();
        }
        catch (Exception exception) {
            throw exception;
        }
        catch (Throwable throwable) {
            throw new IllegalStateException(throwable);
        }
    }
}

