/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon;

import java.util.Iterator;
import java.util.Map;
import org.javasimon.AttributesSupport;
import org.javasimon.HasAttributes;
import org.javasimon.Stopwatch;
import org.javasimon.StopwatchImpl;
import org.javasimon.clock.SimonClock;
import org.javasimon.utils.SimonUtils;

public final class Split
implements HasAttributes,
AutoCloseable {
    public static final Split DISABLED = new Split();
    public static final String ATTR_EFFECTIVE_STOPWATCH = "effective-stopwatch";
    private volatile Stopwatch stopwatch;
    private final boolean enabled;
    private final SimonClock clock;
    private volatile boolean running;
    private volatile long start;
    private volatile long total;
    private AttributesSupport attributesSupport = new AttributesSupport();

    private Split() {
        this.enabled = false;
        this.clock = null;
    }

    private Split(boolean enabled, SimonClock clock) {
        this.enabled = enabled;
        this.clock = clock;
        this.start = clock.nanoTime();
    }

    Split(Stopwatch stopwatch, SimonClock clock, long start) {
        assert (start > 0L) : "start ns value should not be 0 in this constructor!";
        this.stopwatch = stopwatch;
        this.start = start;
        this.clock = clock;
        this.enabled = true;
        this.running = true;
    }

    Split(Stopwatch stopwatch, SimonClock clock) {
        assert (!stopwatch.isEnabled()) : "stopwatch must be disabled in this constructor!";
        this.enabled = false;
        this.stopwatch = stopwatch;
        this.clock = clock;
    }

    public static Split start(SimonClock clock) {
        Split split = new Split(true, clock);
        split.running = true;
        return split;
    }

    public static Split start() {
        return Split.start(SimonClock.SYSTEM);
    }

    public static Split create(long nanos, SimonClock clock) {
        Split split = new Split(false, clock);
        split.total = nanos;
        return split;
    }

    public static Split create(long nanos) {
        return Split.create(nanos, SimonClock.SYSTEM);
    }

    public Stopwatch getStopwatch() {
        return this.stopwatch;
    }

    public Split stop() {
        return this.stop(null);
    }

    public Split stop(String subSimon) {
        if (!this.running) {
            return this;
        }
        this.running = false;
        long nowNanos = this.clock.nanoTime();
        this.total = nowNanos - this.start;
        if (this.stopwatch != null) {
            ((StopwatchImpl)this.stopwatch).stop(this, this.start, nowNanos, subSimon);
        }
        return this;
    }

    public long runningFor() {
        if (!this.running) {
            return this.total;
        }
        if (this.enabled) {
            return this.clock.nanoTime() - this.start;
        }
        return 0L;
    }

    public String presentRunningFor() {
        return SimonUtils.presentNanoTime(this.runningFor());
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isRunning() {
        return this.running;
    }

    public long getStart() {
        return this.start;
    }

    public long getStartMillis() {
        return this.clock != null ? this.clock.millisForNano(this.start) : 0L;
    }

    @Override
    public void setAttribute(String name, Object value) {
        this.attributesSupport.setAttribute(name, value);
    }

    @Override
    public Object getAttribute(String name) {
        return this.attributesSupport.getAttribute(name);
    }

    @Override
    public <T> T getAttribute(String name, Class<T> clazz) {
        return this.attributesSupport.getAttribute(name, clazz);
    }

    @Override
    public void removeAttribute(String name) {
        this.attributesSupport.removeAttribute(name);
    }

    @Override
    public Iterator<String> getAttributeNames() {
        return this.attributesSupport.getAttributeNames();
    }

    @Override
    public Map<String, Object> getCopyAsSortedMap() {
        return this.attributesSupport.getCopyAsSortedMap();
    }

    @Override
    public void close() {
        this.stop();
    }

    public String toString() {
        if (!this.enabled) {
            return "Split created from disabled Stopwatch";
        }
        if (this.running) {
            return "Running split" + (this.stopwatch != null ? " for Stopwatch '" + this.stopwatch.getName() + "': " : ": ") + SimonUtils.presentNanoTime(this.runningFor());
        }
        return "Stopped split" + (this.stopwatch != null ? " for Stopwatch '" + this.stopwatch.getName() + "': " : ": ") + SimonUtils.presentNanoTime(this.total);
    }
}

