/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon;

import org.javasimon.Counter;
import org.javasimon.Simon;
import org.javasimon.SimonException;
import org.javasimon.SimonFilter;
import org.javasimon.Stopwatch;
import org.javasimon.utils.SimonUtils;

public final class SimonPattern
implements SimonFilter {
    private static final String WILDCARD_STAR = "*";
    private final Class<? extends Simon> expectedType;
    private String pattern;
    private String all;
    private String start;
    private String end;
    private String middle;
    private static final String INVALID_PATTERN = "Invalid Simon pattern: ";

    public static SimonPattern create(String pattern) {
        if (pattern == null) {
            return null;
        }
        return SimonPattern.createForType(pattern, Simon.class);
    }

    private static SimonPattern createForType(String pattern, Class<? extends Simon> expectedType) {
        if (pattern == null) {
            return new SimonPattern(WILDCARD_STAR, expectedType);
        }
        return new SimonPattern(pattern, expectedType);
    }

    public static SimonPattern createForCounter(String pattern) {
        return SimonPattern.createForType(pattern, Counter.class);
    }

    public static SimonPattern createForStopwatch(String pattern) {
        return SimonPattern.createForType(pattern, Stopwatch.class);
    }

    public SimonPattern(String pattern) {
        this(pattern, Simon.class);
    }

    public SimonPattern(String pattern, Class<? extends Simon> expectedType) {
        this.expectedType = expectedType;
        this.pattern = pattern;
        if (!pattern.contains(WILDCARD_STAR)) {
            this.all = pattern;
            this.validatePattern(this.all, pattern);
            return;
        }
        if (pattern.equals(WILDCARD_STAR)) {
            this.middle = "";
            return;
        }
        if (pattern.startsWith(WILDCARD_STAR) && pattern.endsWith(WILDCARD_STAR) && pattern.length() > 2) {
            this.middle = pattern.substring(1, pattern.length() - 2);
            this.validatePattern(this.middle, pattern);
            return;
        }
        int ix = pattern.lastIndexOf(42);
        if (ix != pattern.indexOf(42)) {
            throw new SimonException(INVALID_PATTERN + pattern);
        }
        if (!pattern.endsWith(WILDCARD_STAR)) {
            this.end = pattern.substring(ix + 1);
            this.validatePattern(this.end, pattern);
        }
        if (!pattern.startsWith(WILDCARD_STAR)) {
            this.start = pattern.substring(0, ix);
            this.validatePattern(this.start, pattern);
        }
    }

    private void validatePattern(String simonNamePart, String pattern) {
        if (!SimonUtils.checkName(simonNamePart)) {
            throw new SimonException(INVALID_PATTERN + pattern);
        }
    }

    @Override
    public boolean accept(Simon simon) {
        return this.isCorrectType(simon) && this.matches(simon.getName());
    }

    private boolean isCorrectType(Simon simon) {
        return this.expectedType.isInstance(simon);
    }

    public boolean matches(String name) {
        if (name == null) {
            return this.pattern.equals("");
        }
        if (this.all != null) {
            return this.all.equals(name);
        }
        if (this.middle != null) {
            return name.contains(this.middle);
        }
        if (this.start != null && !name.startsWith(this.start)) {
            return false;
        }
        return this.end == null || name.endsWith(this.end);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimonPattern that = (SimonPattern)o;
        if (this.pattern != null ? !this.pattern.equals(that.pattern) : that.pattern != null) {
            return false;
        }
        return !(this.expectedType != null ? !this.expectedType.equals(that.expectedType) : that.expectedType != null);
    }

    public int hashCode() {
        int result = this.expectedType != null ? this.expectedType.hashCode() : 0;
        result = 31 * result + (this.pattern != null ? this.pattern.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "SimonPattern {pattern='" + this.pattern + '\'' + ", expectedType=" + this.expectedType + '}';
    }
}

