/*
 * Decompiled with CFR 0.152.
 */
package org.fishwife.jrugged.clocks;

import org.fishwife.jrugged.clocks.DefaultHardwareClock;
import org.fishwife.jrugged.clocks.HardwareClock;
import org.fishwife.jrugged.interval.DiscreteInterval;

public class Timer {
    private HardwareClock clock;
    private boolean wasSet = false;
    private DiscreteInterval targetElapsedTime;
    private DiscreteInterval startTime;
    private DiscreteInterval targetEndTime;

    public Timer() {
        this(new DefaultHardwareClock());
    }

    public Timer(HardwareClock clock) {
        this.clock = clock;
    }

    public boolean set(long duration, long error) {
        if (error < this.clock.getGranularity()) {
            return false;
        }
        this.wasSet = true;
        this.targetElapsedTime = new DiscreteInterval(duration - error, duration + error);
        return true;
    }

    public void start() {
        if (!this.wasSet) {
            throw new IllegalStateException("cannot start a timer that has not been set");
        }
        this.startTime = this.clock.getNanoTime();
        this.targetEndTime = this.startTime.plus(this.targetElapsedTime);
    }

    public boolean hasElapsed() {
        if (this.startTime == null) {
            return false;
        }
        return this.clock.getNanoTime().getMin() >= this.targetEndTime.getMin();
    }

    public boolean isLate() {
        if (this.startTime == null) {
            return false;
        }
        return this.clock.getNanoTime().getMax() > this.targetEndTime.getMax();
    }

    public DiscreteInterval getTimeRemaining() {
        if (!this.wasSet) {
            throw new IllegalStateException("cannot compute time remaining without having duration set");
        }
        if (this.startTime == null) {
            return this.targetElapsedTime;
        }
        DiscreteInterval diff = this.targetEndTime.minus(this.clock.getNanoTime());
        return diff.getMin() <= 0L ? new DiscreteInterval(0L, 0L) : diff;
    }

    public void waitUntilElapsed() {
        if (!this.wasSet) {
            throw new IllegalStateException("cannot wait until duration has been set");
        }
        while (!this.hasElapsed()) {
        }
    }
}

