/*
 * Decompiled with CFR 0.152.
 */
package org.fishwife.jrugged;

import java.util.concurrent.Callable;
import org.fishwife.jrugged.CallableAdapter;
import org.fishwife.jrugged.ServiceWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceRetrier
implements ServiceWrapper {
    public static final int DEFAULT_MAX_TRIES = 10;
    public static final int DEFAULT_DELAY = 1000;
    private int _delay = 1000;
    private int _maxTries = 10;
    private boolean _doubleDelay = false;
    private boolean _throwCauseException = false;
    private Class<? extends Throwable>[] _retryOn = null;

    public ServiceRetrier(int delay, int maxTries) {
        this.setDelay(delay);
        this.setMaxTries(maxTries);
    }

    public ServiceRetrier(int delay, int maxTries, boolean doubleDelay, boolean throwCauseException, Class<? extends Throwable>[] retryOn) {
        this.setDelay(delay);
        this.setMaxTries(maxTries);
        this.setDoubleDelay(doubleDelay);
        this.setThrowCauseException(throwCauseException);
        this.setRetryOn(retryOn);
    }

    public ServiceRetrier() {
    }

    public <V> V invoke(Callable<V> c) throws Exception {
        int tries = 0;
        int delay = this._delay;
        while (true) {
            try {
                return c.call();
            }
            catch (Exception cause) {
                if (this.shouldRetry(cause) && ++tries < this._maxTries) {
                    if (delay > 0) {
                        this.sleep(delay);
                    }
                    if (!this._doubleDelay) continue;
                    delay *= 2;
                    continue;
                }
                if (this._throwCauseException) {
                    throw cause;
                }
                throw new Exception("Call failed " + tries + " times", cause);
            }
            break;
        }
    }

    private boolean shouldRetry(Throwable cause) {
        if (this._retryOn == null || this._retryOn.length == 0) {
            return true;
        }
        for (Class<? extends Throwable> clazz : this._retryOn) {
            if (!clazz.isInstance(cause)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void invoke(Runnable r) throws Exception {
        CallableAdapter adapter = new CallableAdapter(r);
        this.invoke((Callable<V>)adapter);
    }

    @Override
    public <T> T invoke(Runnable r, T result) throws Exception {
        CallableAdapter<T> adapter = new CallableAdapter<T>(r, result);
        return this.invoke((Callable<V>)adapter);
    }

    public int getDelay() {
        return this._delay;
    }

    public void setDelay(int delay) {
        if (delay < 0) {
            throw new IllegalArgumentException("Delay cannot be negative");
        }
        this._delay = delay;
    }

    public int getMaxTries() {
        return this._maxTries;
    }

    public void setMaxTries(int maxTries) {
        if (maxTries < 1) {
            throw new IllegalArgumentException("Maximum number of tries must be greater than zero");
        }
        this._maxTries = maxTries;
    }

    public boolean isDoubleDelay() {
        return this._doubleDelay;
    }

    public void setDoubleDelay(boolean doubleDelay) {
        this._doubleDelay = doubleDelay;
    }

    public boolean isThrowCauseException() {
        return this._throwCauseException;
    }

    public void setThrowCauseException(boolean throwCauseException) {
        this._throwCauseException = throwCauseException;
    }

    public Class<? extends Throwable>[] getRetryOn() {
        return this._retryOn;
    }

    public void setRetryOn(Class<? extends Throwable>[] retryOn) {
        this._retryOn = retryOn;
    }

    protected void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

