/*
 * Decompiled with CFR 0.152.
 */
package org.fishwife.jrugged;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.fishwife.jrugged.MonitoredService;
import org.fishwife.jrugged.ServiceStatus;
import org.fishwife.jrugged.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RolledUpMonitoredService
implements MonitoredService {
    private String name;
    private Collection<? extends MonitoredService> criticals;
    private Collection<? extends MonitoredService> noncriticals;

    public RolledUpMonitoredService(String name, Collection<? extends MonitoredService> criticals, Collection<? extends MonitoredService> noncriticals) {
        this.name = name;
        this.criticals = criticals;
        this.noncriticals = noncriticals;
    }

    @Override
    public ServiceStatus getServiceStatus() {
        ArrayList<String> reasons = new ArrayList<String>();
        Status criticalStatus = Status.UP;
        for (MonitoredService monitoredService : this.criticals) {
            ServiceStatus serviceStatus = monitoredService.getServiceStatus();
            Status status = serviceStatus.getStatus();
            if (this.statusIsNotUp(status)) {
                for (String reason : serviceStatus.getReasons()) {
                    reasons.add(serviceStatus.getName() + ":" + reason);
                }
            }
            if (status.getValue() >= criticalStatus.getValue()) continue;
            criticalStatus = status;
        }
        Status result = Status.UP;
        for (MonitoredService monitoredService : this.noncriticals) {
            ServiceStatus serviceStatus = monitoredService.getServiceStatus();
            Status status = serviceStatus.getStatus();
            if (!this.statusIsNotUp(status)) continue;
            for (String reason : serviceStatus.getReasons()) {
                reasons.add(serviceStatus.getName() + ":" + reason);
            }
            result = Status.DEGRADED;
        }
        if (criticalStatus.getValue() < result.getValue()) {
            result = criticalStatus;
        }
        return new ServiceStatus(this.name, result, reasons);
    }

    public List<ServiceStatus> getAllStatuses() {
        List<ServiceStatus> list = this.getCriticalStatuses();
        list.addAll(this.getNonCriticalStatuses());
        return list;
    }

    public List<ServiceStatus> getCriticalStatuses() {
        ArrayList<ServiceStatus> list = new ArrayList<ServiceStatus>();
        for (MonitoredService monitoredService : this.criticals) {
            ServiceStatus serviceStatus = monitoredService.getServiceStatus();
            list.add(serviceStatus);
        }
        return list;
    }

    public List<ServiceStatus> getNonCriticalStatuses() {
        ArrayList<ServiceStatus> list = new ArrayList<ServiceStatus>();
        for (MonitoredService monitoredService : this.noncriticals) {
            ServiceStatus serviceStatus = monitoredService.getServiceStatus();
            list.add(serviceStatus);
        }
        return list;
    }

    private boolean statusIsNotUp(Status status) {
        return Status.UP != status;
    }
}

