/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.templating.converter;

import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.requesthandler.AJAXState;
import com.openexchange.ajax.requesthandler.Dispatcher;
import com.openexchange.ajax.tools.JSONCoercion;
import com.openexchange.exception.OXException;
import com.openexchange.session.Session;
import com.openexchange.templating.TemplateErrorMessage;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.session.ServerSessionAdapter;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;

public class Request {
    private final Dispatcher dispatcher;
    private final ServerSession session;
    private final boolean trusted;
    private String action;
    private String module;
    private final Map<String, String> parameters = new HashMap<String, String>();
    private Object body;

    public Request(Dispatcher dispatcher, ServerSession session, boolean trusted) {
        this.dispatcher = dispatcher;
        this.session = session;
        this.trusted = trusted;
    }

    public Request action(String action) {
        this.action = action;
        return this;
    }

    public Request module(String module) {
        this.module = module;
        return this;
    }

    public Request param(String name, Object value) {
        this.parameters.put(name, value.toString());
        return this;
    }

    public Request body(Object body) {
        this.body = body;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object perform() throws OXException {
        if (!this.trusted) {
            throw TemplateErrorMessage.AccessDenied.create();
        }
        AJAXRequestData req = new AJAXRequestData();
        req.setHostname("localhost");
        req.setAction(this.action);
        req.setServletRequestURI("");
        for (Map.Entry<String, String> param : this.parameters.entrySet()) {
            req.putParameter(param.getKey(), param.getValue());
        }
        req.setModule(this.module);
        try {
            req.setData(JSONCoercion.coerceToJSON((Object)this.body));
        }
        catch (JSONException e) {
            throw AjaxExceptionCodes.JSON_ERROR.create(new Object[]{e.toString()});
        }
        AJAXState state = null;
        try {
            state = this.dispatcher.begin();
            req.setFormat("native");
            AJAXRequestResult result = this.dispatcher.perform(req, state, ServerSessionAdapter.valueOf((Session)this.session));
            Object object = result.getResultObject();
            return object;
        }
        finally {
            this.dispatcher.end(state);
        }
    }
}

