/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.property;

import ezvcard.VCard;
import ezvcard.VCardVersion;
import ezvcard.Warning;
import ezvcard.parameter.MediaTypeParameter;
import ezvcard.parameter.Pid;
import ezvcard.property.HasAltId;
import ezvcard.property.VCardProperty;
import ezvcard.util.IOUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BinaryProperty<T extends MediaTypeParameter>
extends VCardProperty
implements HasAltId {
    protected byte[] data;
    protected String url;
    protected T contentType;

    public BinaryProperty() {
    }

    public BinaryProperty(String url, T type) {
        this.setUrl(url, type);
    }

    public BinaryProperty(byte[] data, T type) {
        this.setData(data, type);
    }

    public BinaryProperty(InputStream in, T type) throws IOException {
        this(IOUtils.toByteArray(in, true), type);
    }

    public BinaryProperty(File file, T type) throws IOException {
        this(new BufferedInputStream(new FileInputStream(file)), type);
    }

    public BinaryProperty(BinaryProperty<T> original) {
        super(original);
        this.data = original.data == null ? null : Arrays.copyOf(original.data, original.data.length);
        this.url = original.url;
        this.contentType = original.contentType;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data, T type) {
        this.url = null;
        this.data = data;
        this.setContentType(type);
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url, T type) {
        this.url = url;
        this.data = null;
        this.setContentType(type);
    }

    public T getContentType() {
        return this.contentType;
    }

    public void setContentType(T contentType) {
        this.contentType = contentType;
    }

    public String getType() {
        return this.parameters.getType();
    }

    public void setType(String type) {
        this.parameters.setType(type);
    }

    @Override
    public List<Pid> getPids() {
        return super.getPids();
    }

    @Override
    public Integer getPref() {
        return super.getPref();
    }

    @Override
    public void setPref(Integer pref) {
        super.setPref(pref);
    }

    @Override
    public String getAltId() {
        return this.parameters.getAltId();
    }

    @Override
    public void setAltId(String altId) {
        this.parameters.setAltId(altId);
    }

    @Override
    protected void _validate(List<Warning> warnings, VCardVersion version, VCard vcard) {
        if (this.url == null && this.data == null) {
            warnings.add(new Warning(8, new Object[0]));
        }
    }

    @Override
    protected Map<String, Object> toStringValues() {
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
        values.put("data", this.data == null ? "null" : "length: " + this.data.length);
        values.put("url", this.url);
        values.put("contentType", this.contentType);
        return values;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.contentType == null ? 0 : ((MediaTypeParameter)this.contentType).hashCode());
        result = 31 * result + Arrays.hashCode(this.data);
        result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        BinaryProperty other = (BinaryProperty)obj;
        if (this.contentType == null ? other.contentType != null : !((MediaTypeParameter)this.contentType).equals(other.contentType)) {
            return false;
        }
        if (!Arrays.equals(this.data, other.data)) {
            return false;
        }
        return !(this.url == null ? other.url != null : !this.url.equals(other.url));
    }
}

