/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.io.scribe;

import ezvcard.Messages;
import ezvcard.VCardDataType;
import ezvcard.VCardVersion;
import ezvcard.io.CannotParseException;
import ezvcard.io.html.HCardElement;
import ezvcard.io.json.JCardValue;
import ezvcard.io.scribe.VCardPropertyScribe;
import ezvcard.io.xml.XCardElement;
import ezvcard.parameter.VCardParameters;
import ezvcard.property.Timezone;
import ezvcard.util.UtcOffset;
import java.util.List;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimezoneScribe
extends VCardPropertyScribe<Timezone> {
    public TimezoneScribe() {
        super(Timezone.class, "TZ");
    }

    @Override
    protected VCardDataType _defaultDataType(VCardVersion version) {
        switch (version) {
            case V2_1: 
            case V3_0: {
                return VCardDataType.UTC_OFFSET;
            }
            case V4_0: {
                return VCardDataType.TEXT;
            }
        }
        return null;
    }

    @Override
    protected VCardDataType _dataType(Timezone property, VCardVersion version) {
        String text = property.getText();
        UtcOffset offset = property.getOffset();
        switch (version) {
            case V2_1: {
                return VCardDataType.UTC_OFFSET;
            }
            case V3_0: {
                if (offset != null) {
                    return VCardDataType.UTC_OFFSET;
                }
                if (text == null) break;
                return VCardDataType.TEXT;
            }
            case V4_0: {
                if (text != null) {
                    return VCardDataType.TEXT;
                }
                if (offset == null) break;
                return VCardDataType.UTC_OFFSET;
            }
        }
        return this._defaultDataType(version);
    }

    @Override
    protected String _writeText(Timezone property, VCardVersion version) {
        String text = property.getText();
        UtcOffset offset = property.getOffset();
        switch (version) {
            case V2_1: {
                TimeZone timezone;
                if (offset != null) {
                    return offset.toString(false);
                }
                if (text == null || (timezone = this.timezoneFromId(text)) == null) break;
                UtcOffset tzOffset = this.offsetFromTimezone(timezone);
                return tzOffset.toString(false);
            }
            case V3_0: {
                if (offset != null) {
                    return offset.toString(true);
                }
                if (text == null) break;
                return TimezoneScribe.escape(text);
            }
            case V4_0: {
                if (text != null) {
                    return TimezoneScribe.escape(text);
                }
                if (offset == null) break;
                return offset.toString(false);
            }
        }
        return "";
    }

    @Override
    protected Timezone _parseText(String value, VCardDataType dataType, VCardVersion version, VCardParameters parameters, List<String> warnings) {
        value = TimezoneScribe.unescape(value);
        return this.parse(value, dataType, version, warnings);
    }

    @Override
    protected void _writeXml(Timezone property, XCardElement parent) {
        String text = property.getText();
        if (text != null) {
            parent.append(VCardDataType.TEXT, text);
            return;
        }
        UtcOffset offset = property.getOffset();
        if (offset != null) {
            parent.append(VCardDataType.UTC_OFFSET, offset.toString(false));
            return;
        }
        parent.append(VCardDataType.TEXT, "");
    }

    @Override
    protected Timezone _parseXml(XCardElement element, VCardParameters parameters, List<String> warnings) {
        String text = element.first(VCardDataType.TEXT);
        if (text != null) {
            return new Timezone(text);
        }
        String utcOffset = element.first(VCardDataType.UTC_OFFSET);
        if (utcOffset != null) {
            try {
                return new Timezone(UtcOffset.parse(utcOffset));
            }
            catch (IllegalArgumentException e) {
                throw new CannotParseException(19, new Object[0]);
            }
        }
        throw TimezoneScribe.missingXmlElements(VCardDataType.TEXT, VCardDataType.UTC_OFFSET);
    }

    @Override
    protected Timezone _parseHtml(HCardElement element, List<String> warnings) {
        return this.parse(element.value(), null, VCardVersion.V3_0, warnings);
    }

    @Override
    protected JCardValue _writeJson(Timezone property) {
        String text = property.getText();
        if (text != null) {
            return JCardValue.single(text);
        }
        UtcOffset offset = property.getOffset();
        if (offset != null) {
            return JCardValue.single(offset.toString(true));
        }
        return JCardValue.single("");
    }

    @Override
    protected Timezone _parseJson(JCardValue value, VCardDataType dataType, VCardParameters parameters, List<String> warnings) {
        String valueStr = value.asSingle();
        return this.parse(valueStr, dataType, VCardVersion.V4_0, warnings);
    }

    private Timezone parse(String value, VCardDataType dataType, VCardVersion version, List<String> warnings) {
        if (value == null || value.length() == 0) {
            return new Timezone((String)null);
        }
        switch (version) {
            case V2_1: {
                try {
                    return new Timezone(UtcOffset.parse(value));
                }
                catch (IllegalArgumentException e) {
                    throw new CannotParseException(19, new Object[0]);
                }
            }
            case V3_0: 
            case V4_0: {
                try {
                    return new Timezone(UtcOffset.parse(value));
                }
                catch (IllegalArgumentException e) {
                    if (dataType == VCardDataType.UTC_OFFSET) {
                        warnings.add(Messages.INSTANCE.getParseMessage(20, new Object[0]));
                    }
                    return new Timezone(value);
                }
            }
        }
        return new Timezone((String)null);
    }

    private UtcOffset offsetFromTimezone(TimeZone timezone) {
        long offsetMs = timezone.getOffset(System.currentTimeMillis());
        return new UtcOffset(offsetMs);
    }

    private TimeZone timezoneFromId(String id) {
        TimeZone timezone = TimeZone.getTimeZone(id);
        return "GMT".equals(timezone.getID()) ? null : timezone;
    }
}

