/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.AbstractSession;
import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.ChainedResultSetFuture;
import com.datastax.driver.core.CloseFuture;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ClusterNameMismatchException;
import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.Configuration;
import com.datastax.driver.core.Connection;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.DefaultPreparedStatement;
import com.datastax.driver.core.DefaultResultSetFuture;
import com.datastax.driver.core.DriverThrowables;
import com.datastax.driver.core.GuavaCompatibility;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.HostConnectionPool;
import com.datastax.driver.core.HostDistance;
import com.datastax.driver.core.Message;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.RequestHandler;
import com.datastax.driver.core.Requests;
import com.datastax.driver.core.Responses;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.StatementWrapper;
import com.datastax.driver.core.exceptions.DriverInternalError;
import com.datastax.driver.core.exceptions.InvalidQueryException;
import com.datastax.driver.core.exceptions.UnsupportedFeatureException;
import com.datastax.driver.core.exceptions.UnsupportedProtocolVersionException;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.datastax.driver.core.policies.ReconnectionPolicy;
import com.datastax.driver.core.policies.SpeculativeExecutionPolicy;
import com.datastax.driver.core.querybuilder.BuiltStatement;
import com.datastax.driver.core.utils.MoreFutures;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.SettableFuture;
import com.google.common.util.concurrent.Uninterruptibles;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SessionManager
extends AbstractSession {
    private static final Logger logger = LoggerFactory.getLogger(Session.class);
    final Cluster cluster;
    final ConcurrentMap<Host, HostConnectionPool> pools;
    final HostConnectionPool.PoolState poolsState;
    private final AtomicReference<ListenableFuture<Session>> initFuture = new AtomicReference();
    final AtomicReference<CloseFuture> closeFuture = new AtomicReference();
    private volatile boolean isInit;
    private volatile boolean isClosing;

    SessionManager(Cluster cluster) {
        this.cluster = cluster;
        this.pools = new ConcurrentHashMap<Host, HostConnectionPool>();
        this.poolsState = new HostConnectionPool.PoolState();
    }

    @Override
    public Session init() {
        try {
            return (Session)Uninterruptibles.getUninterruptibly(this.initAsync());
        }
        catch (ExecutionException e) {
            throw DriverThrowables.propagateCause(e);
        }
    }

    @Override
    public ListenableFuture<Session> initAsync() {
        this.cluster.init();
        ListenableFuture<Session> existing = this.initFuture.get();
        if (existing != null) {
            return existing;
        }
        final SettableFuture myInitFuture = SettableFuture.create();
        if (!this.initFuture.compareAndSet(null, (ListenableFuture<Session>)myInitFuture)) {
            return this.initFuture.get();
        }
        Collection<Host> hosts = this.cluster.getMetadata().allHosts();
        ListenableFuture<?> allPoolsCreatedFuture = this.createPools(hosts);
        ListenableFuture<Object> allPoolsUpdatedFuture = GuavaCompatibility.INSTANCE.transformAsync(allPoolsCreatedFuture, new AsyncFunction<Object, Object>(){

            public ListenableFuture<Object> apply(Object input) throws Exception {
                SessionManager.this.isInit = true;
                return SessionManager.this.updateCreatedPools();
            }
        });
        Futures.addCallback(allPoolsUpdatedFuture, (FutureCallback)new FutureCallback<Object>(){

            public void onSuccess(Object result) {
                myInitFuture.set((Object)SessionManager.this);
            }

            public void onFailure(Throwable t) {
                SessionManager.this.closeAsync();
                myInitFuture.setException(t);
            }
        });
        return myInitFuture;
    }

    private ListenableFuture<?> createPools(Collection<Host> hosts) {
        ArrayList futures = Lists.newArrayListWithCapacity((int)hosts.size());
        for (Host host : hosts) {
            if (host.state == Host.State.DOWN) continue;
            futures.add(this.maybeAddPool(host, null));
        }
        return Futures.allAsList((Iterable)futures);
    }

    @Override
    public String getLoggedKeyspace() {
        return this.poolsState.keyspace;
    }

    @Override
    public ResultSetFuture executeAsync(final Statement statement) {
        if (this.isInit) {
            DefaultResultSetFuture future = new DefaultResultSetFuture(this, this.cluster.manager.protocolVersion(), this.makeRequestMessage(statement, null));
            new RequestHandler(this, future, statement).sendRequest();
            return future;
        }
        final ChainedResultSetFuture chainedFuture = new ChainedResultSetFuture();
        this.initAsync().addListener(new Runnable(){

            @Override
            public void run() {
                DefaultResultSetFuture actualFuture = new DefaultResultSetFuture(SessionManager.this, SessionManager.this.cluster.manager.protocolVersion(), SessionManager.this.makeRequestMessage(statement, null));
                SessionManager.this.execute(actualFuture, statement);
                chainedFuture.setSource(actualFuture);
            }
        }, (Executor)this.executor());
        return chainedFuture;
    }

    @Override
    protected ListenableFuture<PreparedStatement> prepareAsync(String query, Map<String, ByteBuffer> customPayload) {
        Requests.Prepare request = new Requests.Prepare(query);
        request.setCustomPayload(customPayload);
        Connection.Future future = new Connection.Future(request);
        this.execute(future, Statement.DEFAULT);
        return this.toPreparedStatement(query, future);
    }

    @Override
    public CloseFuture closeAsync() {
        CloseFuture future = this.closeFuture.get();
        if (future != null) {
            return future;
        }
        this.isClosing = true;
        this.cluster.manager.removeSession(this);
        ArrayList<CloseFuture> futures = new ArrayList<CloseFuture>(this.pools.size());
        for (HostConnectionPool pool : this.pools.values()) {
            futures.add(pool.closeAsync());
        }
        future = new CloseFuture.Forwarding(futures);
        return this.closeFuture.compareAndSet(null, future) ? future : this.closeFuture.get();
    }

    @Override
    public boolean isClosed() {
        return this.closeFuture.get() != null;
    }

    @Override
    public Cluster getCluster() {
        return this.cluster;
    }

    @Override
    public Session.State getState() {
        return new State(this);
    }

    private ListenableFuture<PreparedStatement> toPreparedStatement(final String query, final Connection.Future future) {
        return GuavaCompatibility.INSTANCE.transformAsync(future, new AsyncFunction<Message.Response, PreparedStatement>(){

            public ListenableFuture<PreparedStatement> apply(Message.Response response) {
                switch (response.type) {
                    case RESULT: {
                        Responses.Result rm = (Responses.Result)response;
                        switch (rm.kind) {
                            case PREPARED: {
                                Responses.Result.Prepared pmsg = (Responses.Result.Prepared)rm;
                                PreparedStatement stmt = DefaultPreparedStatement.fromMessage(pmsg, SessionManager.this.cluster, query, SessionManager.this.poolsState.keyspace);
                                stmt = SessionManager.this.cluster.manager.addPrepared(stmt);
                                if (SessionManager.this.cluster.getConfiguration().getQueryOptions().isPrepareOnAllHosts()) {
                                    return SessionManager.this.prepare(stmt, future.getAddress());
                                }
                                return Futures.immediateFuture((Object)stmt);
                            }
                        }
                        return Futures.immediateFailedFuture((Throwable)new DriverInternalError(String.format("%s response received when prepared statement was expected", new Object[]{rm.kind})));
                    }
                    case ERROR: {
                        return Futures.immediateFailedFuture((Throwable)((Responses.Error)response).asException(future.getAddress()));
                    }
                }
                return Futures.immediateFailedFuture((Throwable)new DriverInternalError(String.format("%s response received when prepared statement was expected", new Object[]{response.type})));
            }
        }, (Executor)this.executor());
    }

    Connection.Factory connectionFactory() {
        return this.cluster.manager.connectionFactory;
    }

    Configuration configuration() {
        return this.cluster.manager.configuration;
    }

    LoadBalancingPolicy loadBalancingPolicy() {
        return this.cluster.manager.loadBalancingPolicy();
    }

    SpeculativeExecutionPolicy speculativeExecutionPolicy() {
        return this.cluster.manager.speculativeExecutionPolicy();
    }

    ReconnectionPolicy reconnectionPolicy() {
        return this.cluster.manager.reconnectionPolicy();
    }

    ListeningExecutorService executor() {
        return this.cluster.manager.executor;
    }

    ListeningExecutorService blockingExecutor() {
        return this.cluster.manager.blockingExecutor;
    }

    ListenableFuture<Boolean> forceRenewPool(final Host host, Connection reusedConnection) {
        HostDistance distance = this.cluster.manager.loadBalancingPolicy().distance(host);
        if (distance == HostDistance.IGNORED) {
            return Futures.immediateFuture((Object)true);
        }
        if (this.isClosing) {
            return Futures.immediateFuture((Object)false);
        }
        final HostConnectionPool newPool = new HostConnectionPool(host, distance, this);
        ListenableFuture<Void> poolInitFuture = newPool.initAsync(reusedConnection);
        final SettableFuture future = SettableFuture.create();
        Futures.addCallback(poolInitFuture, (FutureCallback)new FutureCallback<Void>(){

            public void onSuccess(Void result) {
                HostConnectionPool previous = SessionManager.this.pools.put(host, newPool);
                if (previous == null) {
                    logger.debug("Added connection pool for {}", (Object)host);
                } else {
                    logger.debug("Renewed connection pool for {}", (Object)host);
                    previous.closeAsync();
                }
                if (SessionManager.this.isClosing) {
                    newPool.closeAsync();
                    SessionManager.this.pools.remove(host);
                    future.set((Object)false);
                } else {
                    future.set((Object)true);
                }
            }

            public void onFailure(Throwable t) {
                logger.warn("Error creating pool to " + host, t);
                future.set((Object)false);
            }
        });
        return future;
    }

    private ListenableFuture<Void> replacePool(final Host host, HostDistance distance, HostConnectionPool previous, Connection reusedConnection) {
        if (this.isClosing) {
            return MoreFutures.VOID_SUCCESS;
        }
        final HostConnectionPool newPool = new HostConnectionPool(host, distance, this);
        if (previous == null) {
            if (this.pools.putIfAbsent(host, newPool) != null) {
                return null;
            }
        } else {
            if (!this.pools.replace(host, previous, newPool)) {
                return null;
            }
            if (!previous.isClosed()) {
                logger.warn("Replacing a pool that wasn't closed. Closing it now, but this was not expected.");
                previous.closeAsync();
            }
        }
        ListenableFuture<Void> poolInitFuture = newPool.initAsync(reusedConnection);
        Futures.addCallback(poolInitFuture, (FutureCallback)new FutureCallback<Void>(){

            public void onSuccess(Void result) {
                if (SessionManager.this.isClosing) {
                    newPool.closeAsync();
                    SessionManager.this.pools.remove(host);
                }
            }

            public void onFailure(Throwable t) {
                SessionManager.this.pools.remove(host);
            }
        });
        return poolInitFuture;
    }

    ListenableFuture<Boolean> maybeAddPool(final Host host, Connection reusedConnection) {
        SettableFuture future;
        ListenableFuture<Void> newPoolInit;
        HostDistance distance = this.cluster.manager.loadBalancingPolicy().distance(host);
        if (distance == HostDistance.IGNORED) {
            return Futures.immediateFuture((Object)true);
        }
        HostConnectionPool previous = (HostConnectionPool)this.pools.get(host);
        if (previous != null && !previous.isClosed()) {
            return Futures.immediateFuture((Object)true);
        }
        do {
            if ((previous = (HostConnectionPool)this.pools.get(host)) != null && !previous.isClosed()) {
                return Futures.immediateFuture((Object)true);
            }
            future = SettableFuture.create();
        } while ((newPoolInit = this.replacePool(host, distance, previous, reusedConnection)) == null);
        Futures.addCallback(newPoolInit, (FutureCallback)new FutureCallback<Void>(){

            public void onSuccess(Void result) {
                logger.debug("Added connection pool for {}", (Object)host);
                future.set((Object)true);
            }

            public void onFailure(Throwable t) {
                if (t instanceof UnsupportedProtocolVersionException) {
                    SessionManager.this.cluster.manager.logUnsupportedVersionProtocol(host, ((UnsupportedProtocolVersionException)t).getUnsupportedVersion());
                    SessionManager.this.cluster.manager.triggerOnDown(host, false);
                } else if (t instanceof ClusterNameMismatchException) {
                    ClusterNameMismatchException e = (ClusterNameMismatchException)t;
                    SessionManager.this.cluster.manager.logClusterNameMismatch(host, e.expectedClusterName, e.actualClusterName);
                    SessionManager.this.cluster.manager.triggerOnDown(host, false);
                } else {
                    logger.warn("Error creating pool to " + host, t);
                }
                if (t instanceof Error) {
                    future.setException(t);
                } else {
                    future.set((Object)false);
                }
            }
        });
        return future;
    }

    CloseFuture removePool(Host host) {
        HostConnectionPool pool = (HostConnectionPool)this.pools.remove(host);
        return pool == null ? CloseFuture.immediateFuture() : pool.closeAsync();
    }

    ListenableFuture<?> updateCreatedPools() {
        if (!this.isInit) {
            return MoreFutures.VOID_SUCCESS;
        }
        final ArrayList<Host> toRemove = new ArrayList<Host>();
        ArrayList poolCreatedFutures = Lists.newArrayList();
        for (Host h : this.cluster.getMetadata().allHosts()) {
            HostDistance dist = this.loadBalancingPolicy().distance(h);
            HostConnectionPool pool = (HostConnectionPool)this.pools.get(h);
            if (pool == null) {
                if (dist == HostDistance.IGNORED || h.state != Host.State.UP) continue;
                poolCreatedFutures.add(this.maybeAddPool(h, null));
                continue;
            }
            if (dist == pool.hostDistance) continue;
            if (dist == HostDistance.IGNORED) {
                toRemove.add(h);
                continue;
            }
            pool.hostDistance = dist;
            pool.ensureCoreConnections();
        }
        ListenableFuture allPoolsCreatedFuture = Futures.allAsList((Iterable)poolCreatedFutures);
        return GuavaCompatibility.INSTANCE.transformAsync(allPoolsCreatedFuture, new AsyncFunction<Object, List<Void>>(){

            public ListenableFuture<List<Void>> apply(Object input) throws Exception {
                ArrayList poolRemovedFuture = Lists.newArrayListWithCapacity((int)toRemove.size());
                for (Host h : toRemove) {
                    poolRemovedFuture.add(SessionManager.this.removePool(h));
                }
                return Futures.successfulAsList((Iterable)poolRemovedFuture);
            }
        });
    }

    void updateCreatedPools(Host h) {
        block9: {
            HostDistance dist = this.loadBalancingPolicy().distance(h);
            HostConnectionPool pool = (HostConnectionPool)this.pools.get(h);
            try {
                if (pool == null) {
                    if (dist != HostDistance.IGNORED && h.state == Host.State.UP) {
                        this.maybeAddPool(h, null).get();
                    }
                } else if (dist != pool.hostDistance) {
                    if (dist == HostDistance.IGNORED) {
                        this.removePool(h).get();
                    } else {
                        pool.hostDistance = dist;
                        pool.ensureCoreConnections();
                    }
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                logger.error("Unexpected error while refreshing connection pools", cause);
                if (!(cause instanceof Error)) break block9;
                throw (Error)cause;
            }
        }
    }

    void onDown(Host host) throws InterruptedException, ExecutionException {
        this.removePool(host).force().get();
        this.updateCreatedPools().get();
    }

    void onRemove(Host host) throws InterruptedException, ExecutionException {
        this.onDown(host);
    }

    Message.Request makeRequestMessage(Statement statement, ByteBuffer pagingState) {
        Message.Request request;
        if (!this.isInit) {
            this.init();
        }
        ProtocolVersion protocolVersion = this.cluster.manager.protocolVersion();
        CodecRegistry codecRegistry = this.cluster.manager.configuration.getCodecRegistry();
        ConsistencyLevel consistency = statement.getConsistencyLevel();
        if (consistency == null) {
            consistency = this.configuration().getQueryOptions().getConsistencyLevel();
        }
        ConsistencyLevel serialConsistency = statement.getSerialConsistencyLevel();
        if (protocolVersion.compareTo(ProtocolVersion.V3) < 0 && statement instanceof BatchStatement) {
            if (serialConsistency != null) {
                throw new UnsupportedFeatureException(protocolVersion, "Serial consistency on batch statements is not supported");
            }
        } else if (serialConsistency == null) {
            serialConsistency = this.configuration().getQueryOptions().getSerialConsistencyLevel();
        }
        if (statement.getOutgoingPayload() != null && protocolVersion.compareTo(ProtocolVersion.V4) < 0) {
            throw new UnsupportedFeatureException(protocolVersion, "Custom payloads are only supported since native protocol V4");
        }
        long defaultTimestamp = Long.MIN_VALUE;
        if (protocolVersion.compareTo(ProtocolVersion.V3) >= 0 && (defaultTimestamp = statement.getDefaultTimestamp()) == Long.MIN_VALUE) {
            defaultTimestamp = this.cluster.getConfiguration().getPolicies().getTimestampGenerator().next();
        }
        int fetchSize = statement.getFetchSize();
        ByteBuffer usedPagingState = pagingState;
        if (protocolVersion == ProtocolVersion.V1) {
            assert (pagingState == null);
            if (fetchSize <= 0) {
                fetchSize = -1;
            } else if (fetchSize != Integer.MAX_VALUE) {
                throw new UnsupportedFeatureException(protocolVersion, "Paging is not supported");
            }
        } else if (fetchSize <= 0) {
            fetchSize = this.configuration().getQueryOptions().getFetchSize();
        }
        if (fetchSize == Integer.MAX_VALUE) {
            fetchSize = -1;
        }
        if (pagingState == null) {
            usedPagingState = statement.getPagingState();
        }
        if (statement instanceof StatementWrapper) {
            statement = ((StatementWrapper)statement).getWrappedStatement();
        }
        if (statement instanceof RegularStatement) {
            RegularStatement rs = (RegularStatement)statement;
            if (protocolVersion == ProtocolVersion.V1 && rs instanceof BuiltStatement) {
                ((BuiltStatement)rs).setForceNoValues(true);
            }
            ByteBuffer[] rawPositionalValues = rs.getValues(protocolVersion, codecRegistry);
            Map<String, ByteBuffer> rawNamedValues = rs.getNamedValues(protocolVersion, codecRegistry);
            if (protocolVersion == ProtocolVersion.V1 && (rawPositionalValues != null || rawNamedValues != null)) {
                throw new UnsupportedFeatureException(protocolVersion, "Binary values are not supported");
            }
            if (protocolVersion == ProtocolVersion.V2 && rawNamedValues != null) {
                throw new UnsupportedFeatureException(protocolVersion, "Named values are not supported");
            }
            List<ByteBuffer> positionalValues = rawPositionalValues == null ? Collections.emptyList() : Arrays.asList(rawPositionalValues);
            Map<String, ByteBuffer> namedValues = rawNamedValues == null ? Collections.emptyMap() : rawNamedValues;
            String qString = rs.getQueryString(codecRegistry);
            Requests.QueryProtocolOptions options = new Requests.QueryProtocolOptions(Message.Request.Type.QUERY, consistency, positionalValues, namedValues, false, fetchSize, usedPagingState, serialConsistency, defaultTimestamp);
            request = new Requests.Query(qString, options, statement.isTracing());
        } else if (statement instanceof BoundStatement) {
            BoundStatement bs = (BoundStatement)statement;
            if (!this.cluster.manager.preparedQueries.containsKey(bs.statement.getPreparedId().id)) {
                throw new InvalidQueryException(String.format("Tried to execute unknown prepared query : %s. You may have used a PreparedStatement that was created with another Cluster instance.", bs.statement.getPreparedId().id));
            }
            if (protocolVersion.compareTo(ProtocolVersion.V4) < 0) {
                bs.ensureAllSet();
            }
            boolean skipMetadata = protocolVersion != ProtocolVersion.V1 && bs.statement.getPreparedId().resultSetMetadata != null;
            Requests.QueryProtocolOptions options = new Requests.QueryProtocolOptions(Message.Request.Type.EXECUTE, consistency, Arrays.asList(bs.wrapper.values), Collections.<String, ByteBuffer>emptyMap(), skipMetadata, fetchSize, usedPagingState, serialConsistency, defaultTimestamp);
            request = new Requests.Execute(bs.statement.getPreparedId().id, options, statement.isTracing());
        } else {
            assert (statement instanceof BatchStatement) : statement;
            assert (pagingState == null);
            if (protocolVersion == ProtocolVersion.V1) {
                throw new UnsupportedFeatureException(protocolVersion, "Protocol level batching is not supported");
            }
            BatchStatement bs = (BatchStatement)statement;
            if (protocolVersion.compareTo(ProtocolVersion.V4) < 0) {
                bs.ensureAllSet();
            }
            BatchStatement.IdAndValues idAndVals = bs.getIdAndValues(protocolVersion, codecRegistry);
            Requests.BatchProtocolOptions options = new Requests.BatchProtocolOptions(consistency, serialConsistency, defaultTimestamp);
            request = new Requests.Batch(bs.batchType, idAndVals.ids, idAndVals.values, options, statement.isTracing());
        }
        request.setCustomPayload(statement.getOutgoingPayload());
        return request;
    }

    void execute(final RequestHandler.Callback callback, final Statement statement) {
        if (this.isInit) {
            new RequestHandler(this, callback, statement).sendRequest();
        } else {
            this.initAsync().addListener(new Runnable(){

                @Override
                public void run() {
                    new RequestHandler(SessionManager.this, callback, statement).sendRequest();
                }
            }, (Executor)this.executor());
        }
    }

    private ListenableFuture<PreparedStatement> prepare(PreparedStatement statement, InetSocketAddress toExclude) {
        final String query = statement.getQueryString();
        ArrayList futures = Lists.newArrayListWithExpectedSize((int)this.pools.size());
        for (final Map.Entry entry : this.pools.entrySet()) {
            if (((Host)entry.getKey()).getSocketAddress().equals(toExclude)) continue;
            try {
                ListenableFuture<Connection> connectionFuture = ((HostConnectionPool)entry.getValue()).borrowConnection(0L, TimeUnit.MILLISECONDS, 0);
                ListenableFuture<Message.Response> prepareFuture = GuavaCompatibility.INSTANCE.transformAsync(connectionFuture, new AsyncFunction<Connection, Message.Response>(){

                    public ListenableFuture<Message.Response> apply(final Connection c) throws Exception {
                        Connection.Future responseFuture = c.write(new Requests.Prepare(query));
                        Futures.addCallback((ListenableFuture)responseFuture, (FutureCallback)new FutureCallback<Message.Response>(){

                            public void onSuccess(Message.Response result) {
                                c.release();
                            }

                            public void onFailure(Throwable t) {
                                logger.debug(String.format("Unexpected error while preparing query (%s) on %s", query, entry.getKey()), t);
                                c.release();
                            }
                        });
                        return responseFuture;
                    }
                });
                futures.add(prepareFuture);
            }
            catch (Exception exception) {}
        }
        return Futures.transform((ListenableFuture)Futures.successfulAsList((Iterable)futures), (Function)Functions.constant((Object)statement));
    }

    ResultSetFuture executeQuery(Message.Request msg, Statement statement) {
        DefaultResultSetFuture future = new DefaultResultSetFuture(this, this.configuration().getProtocolOptions().getProtocolVersion(), msg);
        this.execute(future, statement);
        return future;
    }

    void cleanupIdleConnections(long now) {
        for (HostConnectionPool pool : this.pools.values()) {
            pool.cleanupIdleConnections(now);
        }
    }

    private static class State
    implements Session.State {
        private final SessionManager session;
        private final List<Host> connectedHosts;
        private final int[] openConnections;
        private final int[] trashedConnections;
        private final int[] inFlightQueries;

        private State(SessionManager session) {
            this.session = session;
            this.connectedHosts = ImmutableList.copyOf(session.pools.keySet());
            this.openConnections = new int[this.connectedHosts.size()];
            this.trashedConnections = new int[this.connectedHosts.size()];
            this.inFlightQueries = new int[this.connectedHosts.size()];
            int i = 0;
            for (Host h : this.connectedHosts) {
                HostConnectionPool p = (HostConnectionPool)session.pools.get(h);
                if (p == null) {
                    this.openConnections[i] = 0;
                    this.trashedConnections[i] = 0;
                    this.inFlightQueries[i] = 0;
                    continue;
                }
                this.openConnections[i] = p.opened();
                this.inFlightQueries[i] = p.totalInFlight.get();
                this.trashedConnections[i] = p.trashed();
                ++i;
            }
        }

        private int getIdx(Host h) {
            for (int i = 0; i < this.connectedHosts.size(); ++i) {
                if (h != this.connectedHosts.get(i)) continue;
                return i;
            }
            return -1;
        }

        @Override
        public Session getSession() {
            return this.session;
        }

        @Override
        public Collection<Host> getConnectedHosts() {
            return this.connectedHosts;
        }

        @Override
        public int getOpenConnections(Host host) {
            int i = this.getIdx(host);
            return i < 0 ? 0 : this.openConnections[i];
        }

        @Override
        public int getTrashedConnections(Host host) {
            int i = this.getIdx(host);
            return i < 0 ? 0 : this.trashedConnections[i];
        }

        @Override
        public int getInFlightQueries(Host host) {
            int i = this.getIdx(host);
            return i < 0 ? 0 : this.inFlightQueries[i];
        }
    }
}

