/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.obs.api;

import com.openexchange.obs.api.Architecture;
import com.openexchange.obs.api.PackageStatus;
import com.openexchange.obs.api.ProjectReference;
import com.openexchange.obs.api.RepositoryReference;
import com.openexchange.obs.api.State;
import java.util.ArrayList;
import java.util.List;

public final class Result {
    private final ProjectReference project;
    private final RepositoryReference repository;
    private final Architecture arch;
    private final State state;
    private final boolean dirty;
    private final List<PackageStatus> statuses = new ArrayList<PackageStatus>();

    public Result(ProjectReference project, RepositoryReference repository, Architecture arch, State state, boolean dirty) {
        this.project = project;
        this.repository = repository;
        this.arch = arch;
        this.state = state;
        this.dirty = dirty;
    }

    public RepositoryReference getRepository() {
        return this.repository;
    }

    public Architecture getArch() {
        return this.arch;
    }

    public void add(PackageStatus status) {
        this.statuses.add(status);
    }

    public State getState() {
        return this.state;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public PackageStatus[] getStatuses() {
        return this.statuses.toArray(new PackageStatus[this.statuses.size()]);
    }

    public String toString() {
        return this.getRepository().getName() + ':' + this.state.name() + ',' + this.statuses.size();
    }
}

