/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.renderers;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import net.sourceforge.pmd.DataSource;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.renderers.Renderer;

public abstract class AbstractRenderer
implements Renderer {
    protected boolean showSuppressedViolations = true;
    private Writer writer;
    private Report mainReport;

    public void showSuppressedViolations(boolean show) {
        this.showSuppressedViolations = show;
    }

    public String render(Report report) {
        StringWriter w = new StringWriter();
        try {
            this.render(w, report);
        }
        catch (IOException e) {
            throw new Error("StringWriter doesn't throw IOException", e);
        }
        return w.toString();
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    public Writer getWriter() {
        return this.writer;
    }

    public void start() throws IOException {
        this.mainReport = new Report();
    }

    public void startFileAnalysis(DataSource dataSource) {
    }

    public void renderFileReport(Report report) throws IOException {
        this.mainReport.merge(report);
    }

    public void end() throws IOException {
        this.render(this.writer, this.mainReport);
    }
}

