/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2012 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.eventsystem;


/**
 * {@link EventConstants} - Defines standard names for {@code EventHandler} properties and helper methods.
 *
 * @author <a href="mailto:thorben.betten@open-xchange.com">Thorben Betten</a>
 * @since 7.4.2
 */
public final class EventConstants {

    /**
     * Initializes a new {@link EventConstants}.
     */
    private EventConstants() {
        super();
    }

    /**
     * Service registration property specifying the {@code Event} topics of interest to an Event Handler service.
     * <p>
     * Event handlers SHOULD be registered with this property. Each value of this property is a string that describe the topics in which the
     * handler is interested. An asterisk ('*') may be used as a trailing wildcard. Event Handlers which do not have a value for this
     * property must not receive events. More precisely, the value of each string must conform to the following grammar:
     *
     * <pre>
     *  topic-description := '*' | topic ( '/*' )?
     *  topic := token ( '/' token )*
     * </pre>
     * <p>
     * The value of this property must be of type {@code String}, {@code String[]}, or {@code Collection<String>}.
     *
     * @see Event
     */
    public static final String EVENT_TOPIC = "event.topics";

    /**
     * The property name for context identifier.
     */
    public static final String PROP_CONTEXT_ID = "event.contextid";

    // ---------------------------------------------------------------------------------------------------- //

    /**
     * Gets the denoted <code>int</code> property.
     *
     * @param name The property name
     * @param event The event
     * @return The <code>int</code> property or <code>-1</code>
     */
    public static int getIntProperty(final String name, final Event event) {
        if (null == event || null == name) {
            return -1;
        }
        final Object property = event.getProperty(name);
        if (null == property) {
            return -1;
        }
        if (property instanceof Number) {
            return ((Number) property).intValue();
        }
        try {
            return Integer.parseInt(property.toString().trim());
        } catch (final Exception e) {
            return -1;
        }
    }

}
