/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.monitor;

import com.hazelcast.impl.monitor.MemberStateImpl;
import com.hazelcast.monitor.MemberState;
import com.hazelcast.nio.DataSerializable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class TimedMemberState
implements DataSerializable,
Cloneable {
    long time;
    MemberState memberState = null;
    Set<String> instanceNames = null;
    List<String> memberList;
    List<String> executorList;
    Boolean master;
    String clusterName;

    public TimedMemberState clone() {
        TimedMemberState st = new TimedMemberState();
        st.setTime(this.time);
        st.setMemberState(this.memberState);
        st.setInstanceNames(this.instanceNames);
        st.setMemberList(this.memberList);
        st.setMaster(this.master);
        st.setClusterName(this.clusterName);
        return st;
    }

    @Override
    public void writeData(DataOutput out) throws IOException {
        out.writeLong(this.time);
        out.writeBoolean(this.master);
        this.memberState.writeData(out);
        out.writeUTF(this.clusterName);
        int nameCount = this.instanceNames == null ? 0 : this.instanceNames.size();
        out.writeInt(nameCount);
        if (this.instanceNames != null) {
            for (String name : this.instanceNames) {
                out.writeUTF(name);
            }
        }
        int memberCount = this.memberList == null ? 0 : this.memberList.size();
        out.writeInt(memberCount);
        if (this.memberList != null) {
            for (String address : this.memberList) {
                out.writeUTF(address);
            }
        }
        int execCount = this.executorList == null ? 0 : this.executorList.size();
        out.writeInt(execCount);
        if (this.executorList != null) {
            for (String exec : this.executorList) {
                out.writeUTF(exec);
            }
        }
    }

    @Override
    public void readData(DataInput in) throws IOException {
        this.time = in.readLong();
        this.master = in.readBoolean();
        this.memberState = new MemberStateImpl();
        this.memberState.readData(in);
        this.clusterName = in.readUTF();
        int nameCount = in.readInt();
        this.instanceNames = new HashSet<String>(nameCount);
        int i = 0;
        while (i < nameCount) {
            this.instanceNames.add(in.readUTF());
            ++i;
        }
        int memberCount = in.readInt();
        this.memberList = new ArrayList<String>();
        int i2 = 0;
        while (i2 < memberCount) {
            this.memberList.add(in.readUTF());
            ++i2;
        }
        int execCount = in.readInt();
        this.executorList = new ArrayList<String>();
        int i3 = 0;
        while (i3 < execCount) {
            this.executorList.add(in.readUTF());
            ++i3;
        }
    }

    public List<String> getMemberList() {
        return this.memberList;
    }

    public void setMemberList(List<String> memberList) {
        this.memberList = memberList;
    }

    public Boolean getMaster() {
        return this.master;
    }

    public void setMaster(Boolean master) {
        this.master = master;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public long getTime() {
        return this.time;
    }

    public Set<String> getInstanceNames() {
        return this.instanceNames;
    }

    public void setInstanceNames(Set<String> longInstanceNames) {
        this.instanceNames = longInstanceNames;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TimedMemberState{\n");
        sb.append("\t");
        sb.append(this.memberState);
        sb.append("\n");
        sb.append("}\n");
        sb.append("Instances : ");
        sb.append(this.instanceNames);
        return sb.toString();
    }

    public MemberState getMemberState() {
        return this.memberState;
    }

    public void setMemberState(MemberState memberState) {
        this.memberState = memberState;
    }

    public List<String> getExecutorList() {
        return this.executorList;
    }

    public void setExecutorList(List<String> executorList) {
        this.executorList = executorList;
    }
}

