/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.partition;

import com.hazelcast.config.PartitionGroupConfig;
import com.hazelcast.impl.Util;
import com.hazelcast.impl.partition.ConfigMemberGroupFactory;
import com.hazelcast.impl.partition.HostAwareMemberGroupFactory;
import com.hazelcast.impl.partition.MemberGroupFactory;
import com.hazelcast.impl.partition.PartitionStateGenerator;
import com.hazelcast.impl.partition.PartitionStateGeneratorImpl;
import com.hazelcast.impl.partition.SingleMemberGroupFactory;
import com.hazelcast.nio.Serializer;

public class PartitionStateGeneratorFactory {
    public static PartitionStateGenerator newRandomPartitionStateGenerator() {
        return new PartitionStateGeneratorImpl(new SingleMemberGroupFactory());
    }

    public static PartitionStateGenerator newHostAwarePartitionStateGenerator() {
        return new PartitionStateGeneratorImpl(new HostAwareMemberGroupFactory());
    }

    public static PartitionStateGenerator newConfigPartitionStateGenerator(PartitionGroupConfig partitionGroupConfig) {
        return PartitionStateGeneratorFactory.newCustomPartitionStateGenerator(PartitionStateGeneratorFactory.newMemberGroupFactory(partitionGroupConfig));
    }

    public static PartitionStateGenerator newCustomPartitionStateGenerator(MemberGroupFactory nodeGroupFactory) {
        return new PartitionStateGeneratorImpl(nodeGroupFactory);
    }

    public static MemberGroupFactory newMemberGroupFactory(PartitionGroupConfig partitionGroupConfig) {
        if (partitionGroupConfig == null || !partitionGroupConfig.isEnabled()) {
            return new SingleMemberGroupFactory();
        }
        switch (partitionGroupConfig.getGroupType()) {
            case HOST_AWARE: {
                return new HostAwareMemberGroupFactory();
            }
            case CUSTOM: {
                if (partitionGroupConfig.getMemberGroupFactoryClassname() != null) {
                    try {
                        MemberGroupFactory f = (MemberGroupFactory)Serializer.newInstance(partitionGroupConfig.getMemberGroupFactoryClassname());
                        return f;
                    }
                    catch (Exception e) {
                        Util.throwUncheckedException(e);
                    }
                }
                return new ConfigMemberGroupFactory(partitionGroupConfig.getMemberGroupConfigs());
            }
        }
        return new SingleMemberGroupFactory();
    }
}

