/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.monitor;

import com.hazelcast.impl.monitor.LocalOperationStatsSupport;
import com.hazelcast.monitor.LocalExecutorOperationStats;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;

public class LocalExecutorOperationStatsImpl
extends LocalOperationStatsSupport
implements LocalExecutorOperationStats {
    private String executorName;
    final AtomicLong pending = new AtomicLong(0L);
    final AtomicLong started = new AtomicLong(0L);
    final AtomicLong startLatency = new AtomicLong(0L);
    final AtomicLong completed = new AtomicLong(0L);
    final AtomicLong completionTime = new AtomicLong(0L);
    final AtomicLong minCompletionTime = new AtomicLong(Long.MAX_VALUE);
    final AtomicLong maxCompletionTime = new AtomicLong(Long.MIN_VALUE);

    public LocalExecutorOperationStatsImpl(String executorName) {
        this.executorName = executorName;
    }

    public String getExecutorName() {
        return this.executorName;
    }

    @Override
    public long getPending() {
        return this.pending.get();
    }

    @Override
    public long getStarted() {
        return this.started.get();
    }

    @Override
    public long getStartLatency() {
        return this.startLatency.get();
    }

    @Override
    public long getAverageStartLatency() {
        if (this.started.get() == 0L) {
            return 0L;
        }
        return this.startLatency.get() / this.started.get();
    }

    @Override
    public long getCompleted() {
        return this.completed.get();
    }

    @Override
    public long getCompletionTime() {
        return this.completionTime.get();
    }

    @Override
    public long getMinCompletionTime() {
        return this.minCompletionTime.get();
    }

    @Override
    public long getAverageCompletionTime() {
        if (this.completed.get() == 0L) {
            return 0L;
        }
        return this.completionTime.get() / this.completed.get();
    }

    @Override
    public long getMaxCompletionTime() {
        return this.maxCompletionTime.get();
    }

    @Override
    public void writeDataInternal(DataOutput out) throws IOException {
        out.writeUTF(this.executorName);
        out.writeLong(this.pending.get());
        out.writeLong(this.started.get());
        out.writeLong(this.startLatency.get());
        out.writeLong(this.completed.get());
        out.writeLong(this.completionTime.get());
        out.writeLong(this.minCompletionTime.get());
        out.writeLong(this.maxCompletionTime.get());
    }

    @Override
    public void readDataInternal(DataInput in) throws IOException {
        this.executorName = in.readUTF();
        this.pending.set(in.readLong());
        this.started.set(in.readLong());
        this.startLatency.set(in.readLong());
        this.completed.set(in.readLong());
        this.completionTime.set(in.readLong());
        this.minCompletionTime.set(in.readLong());
        this.maxCompletionTime.set(in.readLong());
    }
}

