/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.management;

import com.hazelcast.core.IMap;
import com.hazelcast.core.MapEntry;
import com.hazelcast.impl.management.ConsoleRequest;
import com.hazelcast.impl.management.ManagementCenterService;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.TreeMap;

public class GetMapEntryRequest
implements ConsoleRequest {
    private String mapName;
    private String type;
    private String key;

    public GetMapEntryRequest() {
    }

    public GetMapEntryRequest(String type, String mapName, String key) {
        this.type = type;
        this.mapName = mapName;
        this.key = key;
    }

    @Override
    public int getType() {
        return 12;
    }

    @Override
    public Object readResponse(DataInput in) throws IOException {
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        int size = in.readInt();
        int i = 0;
        while (i < size) {
            String[] temp = in.readUTF().split(":#");
            properties.put(temp[0], temp.length == 1 ? "" : temp[1]);
            ++i;
        }
        return properties;
    }

    @Override
    public void writeResponse(ManagementCenterService mcs, DataOutput dos) throws Exception {
        Object value;
        IMap map = mcs.getHazelcastInstance().getMap(this.mapName);
        MapEntry entry = null;
        if (this.type.equals("string")) {
            entry = map.getMapEntry(this.key);
        } else if (this.type.equals("long")) {
            entry = map.getMapEntry(Long.valueOf(this.key));
        } else if (this.type.equals("integer")) {
            entry = map.getMapEntry(Integer.valueOf(this.key));
        }
        TreeMap<String, String> result = new TreeMap<String, String>();
        if (entry == null) {
            result.put("No Value Found!", " ");
        }
        result.put("browse_value", (value = entry.getValue()) != null ? value.toString() : "null");
        result.put("browse_class", value != null ? value.getClass().getName() : "null");
        result.put("memory_cost", Long.toString(entry.getCost()));
        result.put("date_creation_time", Long.toString(entry.getCreationTime()));
        result.put("date_expiration_time", Long.toString(entry.getExpirationTime()));
        result.put("browse_hits", Integer.toString(entry.getHits()));
        result.put("date_access_time", Long.toString(entry.getLastAccessTime()));
        result.put("date_update_time", Long.toString(entry.getLastUpdateTime()));
        result.put("browse_version", Long.toString(entry.getVersion()));
        result.put("boolean_valid", Boolean.toString(entry.isValid()));
        dos.writeInt(result.size());
        for (Object property : result.keySet()) {
            dos.writeUTF(String.valueOf((String)property) + ":#" + (String)result.get(property));
        }
    }

    @Override
    public void writeData(DataOutput out) throws IOException {
        out.writeUTF(this.type);
        out.writeUTF(this.mapName);
        out.writeUTF(this.key);
    }

    @Override
    public void readData(DataInput in) throws IOException {
        this.type = in.readUTF();
        this.mapName = in.readUTF();
        this.key = in.readUTF();
    }
}

