/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.concurrentmap;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceAware;
import com.hazelcast.core.IMap;
import com.hazelcast.impl.CMap;
import com.hazelcast.impl.ConcurrentMapManager;
import com.hazelcast.impl.FactoryImpl;
import com.hazelcast.impl.Processable;
import com.hazelcast.impl.base.KeyValue;
import com.hazelcast.impl.base.Pairs;
import com.hazelcast.nio.DataSerializable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;

public class PutAllCallable
implements Callable<Boolean>,
HazelcastInstanceAware,
DataSerializable {
    private String mapName;
    private Pairs pairs;
    private FactoryImpl factory = null;

    public PutAllCallable() {
    }

    public PutAllCallable(String mapName, Pairs pairs) {
        this.mapName = mapName;
        this.pairs = pairs;
    }

    @Override
    public Boolean call() throws Exception {
        final ConcurrentMapManager c = this.factory.node.concurrentMapManager;
        CMap cmap = c.getMap(this.mapName);
        if (cmap == null) {
            c.enqueueAndWait(new Processable(){

                @Override
                public void process() {
                    c.getOrCreateMap(PutAllCallable.this.mapName);
                }
            }, 100);
            cmap = c.getMap(this.mapName);
        }
        if (cmap != null) {
            IMap map = (IMap)this.factory.getOrCreateProxyByName(cmap.getName());
            for (KeyValue keyValue : this.pairs.getKeyValues()) {
                Object value = cmap.getMapIndexService().hasIndexedAttributes() ? keyValue.getValue() : keyValue.getValueData();
                map.set(keyValue.getKeyData(), value, 0L, TimeUnit.SECONDS);
            }
        }
        return Boolean.TRUE;
    }

    @Override
    public void readData(DataInput in) throws IOException {
        this.mapName = in.readUTF();
        this.pairs = new Pairs();
        this.pairs.readData(in);
    }

    @Override
    public void writeData(DataOutput out) throws IOException {
        out.writeUTF(this.mapName);
        this.pairs.writeData(out);
    }

    @Override
    public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
        this.factory = (FactoryImpl)hazelcastInstance;
    }
}

