/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.cluster.JoinInfo;
import com.hazelcast.config.Config;
import com.hazelcast.core.Member;
import com.hazelcast.impl.Joiner;
import com.hazelcast.impl.MemberImpl;
import com.hazelcast.impl.Node;
import com.hazelcast.impl.Processable;
import com.hazelcast.impl.base.SystemLogService;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.util.Clock;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;

public abstract class AbstractJoiner
implements Joiner {
    private final AtomicLong joinStartTime = new AtomicLong(Clock.currentTimeMillis());
    private final AtomicInteger tryCount = new AtomicInteger(0);
    protected final Config config;
    protected final Node node;
    protected final ILogger logger;
    protected final SystemLogService systemLogService;
    protected Address targetAddress;

    public AbstractJoiner(Node node) {
        this.node = node;
        this.systemLogService = node.getSystemLogService();
        this.logger = node.loggingService.getLogger(this.getClass().getName());
        this.config = node.config;
    }

    public abstract void doJoin(AtomicBoolean var1);

    @Override
    public void join(AtomicBoolean joined) {
        this.doJoin(joined);
        this.postJoin();
    }

    private void postJoin() {
        this.systemLogService.logJoin("PostJoin master: " + this.node.getMasterAddress() + ", isMaster: " + this.node.isMaster());
        if (!this.node.isActive()) {
            return;
        }
        if (this.tryCount.incrementAndGet() == 5) {
            this.logger.log(Level.WARNING, "Join try count exceed limit, setting this node as master!");
            this.node.setAsMaster();
        }
        if (!this.node.isMaster()) {
            boolean allConnected = false;
            int checkCount = 0;
            long maxJoinMillis = this.node.getGroupProperties().MAX_JOIN_SECONDS.getInteger() * 1000;
            if (this.node.joined()) {
                this.systemLogService.logJoin("Waiting for all connections");
                while (checkCount++ < this.node.groupProperties.CONNECT_ALL_WAIT_SECONDS.getInteger() && !allConnected) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    Set<Member> members = this.node.getClusterImpl().getMembers();
                    allConnected = true;
                    for (Member member : members) {
                        MemberImpl memberImpl = (MemberImpl)member;
                        if (memberImpl.localMember() || this.node.connectionManager.getConnection(memberImpl.getAddress()) != null) continue;
                        allConnected = false;
                        this.systemLogService.logJoin("Not-connected to " + memberImpl.getAddress());
                    }
                }
            }
            if (!this.node.joined() || !allConnected) {
                if (Clock.currentTimeMillis() - this.getStartTime() < maxJoinMillis) {
                    this.logger.log(Level.WARNING, "Failed to connect, node joined= " + this.node.joined() + ", allConnected= " + allConnected + " to all other members after " + checkCount + " seconds.");
                    this.logger.log(Level.WARNING, "Rebooting after 10 seconds.");
                    try {
                        Thread.sleep(10000L);
                        this.node.rejoin();
                    }
                    catch (InterruptedException e) {
                        this.logger.log(Level.WARNING, e.getMessage(), e);
                        this.node.shutdown(false, true);
                    }
                } else {
                    throw new RuntimeException("Failed to join in " + maxJoinMillis / 1000L + " seconds!");
                }
                return;
            }
            this.node.clusterManager.finalizeJoin();
        }
        this.node.clusterManager.enqueueAndWait(new Processable(){

            @Override
            public void process() {
                if (AbstractJoiner.this.node.baseVariables.lsMembers.size() == 1) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("\n");
                    sb.append(AbstractJoiner.this.node.clusterManager);
                    AbstractJoiner.this.logger.log(Level.INFO, sb.toString());
                }
            }
        }, 5);
    }

    protected void failedJoiningToMaster(boolean multicast, int tryCount) {
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        sb.append("======================================================");
        sb.append("\n");
        sb.append("Couldn't connect to discovered master! tryCount: ").append(tryCount);
        sb.append("\n");
        sb.append("address: ").append(this.node.address);
        sb.append("\n");
        sb.append("masterAddress: ").append(this.node.getMasterAddress());
        sb.append("\n");
        sb.append("multicast: ").append(multicast);
        sb.append("\n");
        sb.append("connection: ").append(this.node.connectionManager.getConnection(this.node.getMasterAddress()));
        sb.append("\n");
        sb.append("======================================================");
        sb.append("\n");
        throw new IllegalStateException(sb.toString());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean shouldMerge(JoinInfo joinInfo) {
        boolean shouldMerge = false;
        if (joinInfo == null) return shouldMerge;
        try {
            int currentMemberCount;
            block7: {
                Member member;
                MemberImpl memberImpl;
                boolean validJoinRequest;
                try {
                    validJoinRequest = this.node.validateJoinRequest(joinInfo);
                }
                catch (Exception e) {
                    this.logger.log(Level.FINEST, e.getMessage());
                    validJoinRequest = false;
                }
                if (!validJoinRequest) return shouldMerge;
                Iterator<Member> iterator = this.node.getClusterImpl().getMembers().iterator();
                do {
                    if (iterator.hasNext()) continue;
                    currentMemberCount = this.node.getClusterImpl().getMembers().size();
                    if (joinInfo.getMemberCount() > currentMemberCount) {
                        this.logger.log(Level.INFO, this.node.address + " is merging to " + joinInfo.address + ", because : joinInfo.getMemberCount() > currentMemberCount [" + joinInfo.getMemberCount() + " > " + currentMemberCount + "]");
                        this.logger.log(Level.FINEST, joinInfo.toString());
                        return true;
                    }
                    break block7;
                } while (!(memberImpl = (MemberImpl)(member = iterator.next())).getAddress().equals(joinInfo.address));
                this.logger.log(Level.FINEST, "Should not merge to " + joinInfo.address + ", because it is already member of this cluster.");
                return false;
            }
            if (joinInfo.getMemberCount() != currentMemberCount) return shouldMerge;
            if (this.node.getThisAddress().hashCode() > joinInfo.address.hashCode()) {
                this.logger.log(Level.INFO, this.node.address + " is merging to " + joinInfo.address + ", because : node.getThisAddress().hashCode() > joinInfo.address.hashCode() " + ", this node member count: " + currentMemberCount);
                this.logger.log(Level.FINEST, joinInfo.toString());
                return true;
            }
            this.logger.log(Level.FINEST, joinInfo.address + " should merge to this node " + ", because : node.getThisAddress().hashCode() < joinInfo.address.hashCode() " + ", this node member count: " + currentMemberCount);
            return shouldMerge;
        }
        catch (Throwable e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
            return false;
        }
    }

    protected void connectAndSendJoinRequest(Collection<Address> colPossibleAddresses) {
        for (Address possibleAddress : colPossibleAddresses) {
            Connection conn = this.node.connectionManager.getOrConnect(possibleAddress);
            if (conn == null) continue;
            this.logger.log(Level.FINEST, "sending join request for " + possibleAddress);
            this.node.clusterManager.sendJoinRequest(possibleAddress, true);
        }
    }

    @Override
    public void reset() {
        this.joinStartTime.set(Clock.currentTimeMillis());
        this.tryCount.set(0);
    }

    @Override
    public final long getStartTime() {
        return this.joinStartTime.get();
    }

    @Override
    public void setTargetAddress(Address targetAddress) {
        this.targetAddress = targetAddress;
    }
}

