/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.bus.osgi;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.extension.Extension;
import org.apache.cxf.bus.extension.ExtensionFragmentParser;
import org.apache.cxf.bus.extension.ExtensionManagerImpl;
import org.apache.cxf.bus.extension.ExtensionRegistry;
import org.apache.cxf.bus.osgi.OSGiAutomaticWorkQueue;
import org.apache.cxf.buslifecycle.BusCreationListener;
import org.apache.cxf.buslifecycle.BusLifeCycleListener;
import org.apache.cxf.buslifecycle.BusLifeCycleManager;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.configuration.ConfiguredBeanLocator;
import org.apache.cxf.endpoint.ClientLifeCycleListener;
import org.apache.cxf.endpoint.ClientLifeCycleManager;
import org.apache.cxf.endpoint.ServerLifeCycleListener;
import org.apache.cxf.endpoint.ServerLifeCycleManager;
import org.apache.cxf.workqueue.WorkQueueManager;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.framework.Version;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

public class OSGiExtensionLocator
implements BundleActivator,
SynchronousBundleListener {
    private static final Logger LOG = LogUtils.getL7dLogger(OSGiExtensionLocator.class);
    private ConcurrentMap<Long, List<Extension>> extensions = new ConcurrentHashMap<Long, List<Extension>>();
    private long id;
    private Extension listener;
    private OSGiAutomaticWorkQueue.WorkQueueList workQueues = new OSGiAutomaticWorkQueue.WorkQueueList();

    public void bundleChanged(BundleEvent event) {
        if (event.getType() == 32 && this.id != event.getBundle().getBundleId()) {
            try {
                this.register(event.getBundle());
            }
            catch (Exception exception) {}
        } else if (event.getType() == 64 || event.getType() == 16) {
            this.unregister(event.getBundle().getBundleId());
        }
    }

    public void start(BundleContext context) throws Exception {
        context.addBundleListener((BundleListener)this);
        this.id = context.getBundle().getBundleId();
        this.registerBusListener(context);
        for (Bundle bundle : context.getBundles()) {
            if (bundle.getState() != 4 && bundle.getState() != 8 && bundle.getState() != 32 && bundle.getState() != 16 || bundle.getBundleId() == context.getBundle().getBundleId()) continue;
            this.register(bundle);
        }
        ServiceReference configAdminServiceRef = context.getServiceReference(ConfigurationAdmin.class.getName());
        if (configAdminServiceRef != null) {
            ConfigurationAdmin configAdmin = (ConfigurationAdmin)context.getService(configAdminServiceRef);
            Configuration config = configAdmin.getConfiguration("org.apache.cxf.workqueues");
            this.workQueues.register(context, config);
            Dictionary d = config.getProperties();
            if (d != null) {
                this.workQueues.updated(d);
            }
            Extension ext = new Extension(OSGiAutomaticWorkQueue.WorkQueueList.class){

                public Object getLoadedObject() {
                    return OSGiExtensionLocator.this.workQueues;
                }

                public Extension cloneNoObject() {
                    return this;
                }
            };
            ExtensionRegistry.addExtensions(Collections.singletonList(ext));
        }
    }

    public void stop(BundleContext context) throws Exception {
        context.removeBundleListener((BundleListener)this);
        this.unregisterBusListener();
        while (!this.extensions.isEmpty()) {
            this.unregister((Long)this.extensions.keySet().iterator().next());
        }
        for (OSGiAutomaticWorkQueue wq : this.workQueues.queues.values()) {
            wq.setShared(false);
            wq.shutdown(true);
        }
        this.workQueues.queues.clear();
    }

    private void registerBusListener(BundleContext context) {
        this.listener = new Extension(OSGIBusListener.class);
        this.listener.setArgs(new Object[]{context});
        ExtensionRegistry.addExtensions(Collections.singletonList(this.listener));
    }

    private void unregisterBusListener() {
        ExtensionRegistry.removeExtensions(Collections.singletonList(this.listener));
        this.listener = null;
    }

    protected void register(Bundle bundle) throws IOException {
        CopyOnWriteArrayList<Extension> list = (CopyOnWriteArrayList<Extension>)this.extensions.get(bundle.getBundleId());
        Enumeration e = bundle.findEntries("META-INF/cxf/", "bus-extensions.txt", false);
        if (e != null) {
            while (e.hasMoreElements()) {
                URL u = (URL)e.nextElement();
                InputStream ins = u.openStream();
                List<Extension> orig = new ExtensionFragmentParser().getExtensionsFromText(ins);
                ins.close();
                LOG.info("Loading the extension from bundle " + bundle.getBundleId());
                if (orig == null || orig.isEmpty()) continue;
                if (list == null) {
                    list = new CopyOnWriteArrayList<Extension>();
                    this.extensions.put(bundle.getBundleId(), list);
                }
                for (Extension ext : orig) {
                    list.add(new OSGiExtension(ext, bundle));
                }
                ExtensionRegistry.addExtensions(list);
            }
        }
    }

    protected void unregister(long bundleId) {
        List list = (List)this.extensions.remove(bundleId);
        if (list != null) {
            LOG.info("Removed the extensions for bundle " + bundleId);
            ExtensionRegistry.removeExtensions(list);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class OSGiExtension
    extends Extension {
        final Bundle bundle;

        public OSGiExtension(Extension e, Bundle b) {
            super(e);
            this.bundle = b;
        }

        @Override
        public Class<?> getClassObject(ClassLoader cl) {
            if (this.clazz == null) {
                try {
                    this.clazz = this.bundle.loadClass(this.className);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            return super.getClassObject(cl);
        }

        @Override
        public Class<?> loadInterface(ClassLoader cl) {
            try {
                return this.bundle.loadClass(this.interfaceName);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return super.loadInterface(cl);
            }
        }

        @Override
        public Extension cloneNoObject() {
            OSGiExtension ext = new OSGiExtension(this, this.bundle);
            ext.obj = null;
            return ext;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class OSGiBeanLocator
    implements ConfiguredBeanLocator {
        final ConfiguredBeanLocator cbl;
        final BundleContext context;

        public OSGiBeanLocator(ConfiguredBeanLocator c, BundleContext ctx) {
            this.cbl = c;
            this.context = ctx;
        }

        @Override
        public <T> T getBeanOfType(String name, Class<T> type) {
            return this.cbl.getBeanOfType(name, type);
        }

        @Override
        public <T> Collection<? extends T> getBeansOfType(Class<T> type) {
            Collection<T> ret = this.cbl.getBeansOfType(type);
            if (ret == null || ret.isEmpty()) {
                ArrayList<T> list = new ArrayList<T>();
                try {
                    ServiceReference[] refs = this.context.getServiceReferences(type.getName(), null);
                    if (refs != null) {
                        for (ServiceReference r : refs) {
                            list.add(type.cast(this.context.getService(r)));
                        }
                    }
                    if (!list.isEmpty()) {
                        return list;
                    }
                }
                catch (Exception ex) {
                    LOG.info("Try to find the Bean with type:" + type + " from OSGi services and get error: " + ex);
                }
            }
            return ret;
        }

        @Override
        public <T> boolean loadBeansOfType(Class<T> type, ConfiguredBeanLocator.BeanLoaderListener<T> listener) {
            return this.cbl.loadBeansOfType(type, listener);
        }

        @Override
        public boolean hasConfiguredPropertyValue(String beanName, String propertyName, String value) {
            return this.cbl.hasConfiguredPropertyValue(beanName, propertyName, value);
        }

        @Override
        public List<String> getBeanNamesOfType(Class<?> type) {
            return this.cbl.getBeanNamesOfType(type);
        }
    }

    public static class OSGIBusListener
    implements BusLifeCycleListener {
        public static final String CONTEXT_SYMBOLIC_NAME_PROPERTY = "cxf.context.symbolicname";
        public static final String CONTEXT_VERSION_PROPERTY = "cxf.context.version";
        public static final String CONTEXT_NAME_PROPERTY = "cxf.bus.id";
        Bus bus;
        ServiceRegistration service;
        BundleContext defaultContext;

        public OSGIBusListener(Bus b) {
            this(b, null);
        }

        public OSGIBusListener(Bus b, Object[] args) {
            Object listener;
            Object clcm;
            ServiceReference[] refs;
            this.bus = b;
            if (args != null && args.length > 0 && args[0] instanceof BundleContext) {
                this.defaultContext = (BundleContext)args[0];
            }
            BusLifeCycleManager manager = this.bus.getExtension(BusLifeCycleManager.class);
            manager.registerLifeCycleListener(this);
            ConfiguredBeanLocator cbl = this.bus.getExtension(ConfiguredBeanLocator.class);
            if (cbl instanceof ExtensionManagerImpl) {
                this.bus.setExtension(new OSGiBeanLocator(cbl, this.defaultContext), ConfiguredBeanLocator.class);
            }
            try {
                refs = this.defaultContext.getServiceReferences(ClientLifeCycleListener.class.getName(), null);
                if (refs != null) {
                    clcm = this.bus.getExtension(ClientLifeCycleManager.class);
                    for (ServiceReference ref : refs) {
                        if (!this.allowService(ref)) continue;
                        listener = (ClientLifeCycleListener)this.defaultContext.getService(ref);
                        clcm.registerListener((ClientLifeCycleListener)listener);
                    }
                }
            }
            catch (InvalidSyntaxException e) {
                // empty catch block
            }
            try {
                refs = this.defaultContext.getServiceReferences(ServerLifeCycleListener.class.getName(), null);
                if (refs != null) {
                    clcm = this.bus.getExtension(ServerLifeCycleManager.class);
                    for (ServiceReference ref : refs) {
                        if (!this.allowService(ref)) continue;
                        listener = (ServerLifeCycleListener)this.defaultContext.getService(ref);
                        clcm.registerListener((ServerLifeCycleListener)listener);
                    }
                }
            }
            catch (InvalidSyntaxException e) {
                // empty catch block
            }
            try {
                refs = this.defaultContext.getServiceReferences(BusCreationListener.class.getName(), null);
                if (refs != null) {
                    for (ServiceReference ref : refs) {
                        if (!this.allowService(ref)) continue;
                        BusCreationListener listener2 = (BusCreationListener)this.defaultContext.getService(ref);
                        listener2.busCreated(this.bus);
                    }
                }
            }
            catch (InvalidSyntaxException e) {
                // empty catch block
            }
        }

        private boolean allowService(ServiceReference ref) {
            Object o = ref.getProperty("org.apache.cxf.bus.private.extension");
            Boolean pvt = Boolean.FALSE;
            if (o == null) {
                pvt = Boolean.FALSE;
            } else if (o instanceof String) {
                pvt = Boolean.parseBoolean((String)o);
            } else if (o instanceof Boolean) {
                pvt = (Boolean)o;
            }
            return pvt == false;
        }

        private Version getBundleVersion(Bundle bundle) {
            Dictionary headers = bundle.getHeaders();
            String version = (String)headers.get("Bundle-Version");
            return version != null ? Version.parseVersion((String)version) : Version.emptyVersion;
        }

        public void initComplete() {
            BundleContext context;
            WorkQueueManager m = this.bus.getExtension(WorkQueueManager.class);
            OSGiAutomaticWorkQueue.WorkQueueList l = this.bus.getExtension(OSGiAutomaticWorkQueue.WorkQueueList.class);
            if (l != null && m != null) {
                for (OSGiAutomaticWorkQueue wq : l.queues.values()) {
                    if (m.getNamedWorkQueue(wq.getName()) != null) continue;
                    m.addNamedWorkQueue(wq.getName(), wq);
                }
            }
            if ((context = this.bus.getExtension(BundleContext.class)) != null) {
                Properties props = new Properties();
                props.put(CONTEXT_SYMBOLIC_NAME_PROPERTY, context.getBundle().getSymbolicName());
                props.put(CONTEXT_VERSION_PROPERTY, this.getBundleVersion(context.getBundle()));
                props.put(CONTEXT_NAME_PROPERTY, this.bus.getId());
                this.service = context.registerService(Bus.class.getName(), (Object)this.bus, (Dictionary)props);
            }
        }

        public void preShutdown() {
        }

        public void postShutdown() {
            if (this.service != null) {
                this.service.unregister();
                this.service = null;
            }
        }
    }
}

