/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling;

import com.amazonaws.services.dynamodbv2.datamodeling.S3ClientCache;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.internal.BucketNameUtils;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectResult;
import com.amazonaws.services.s3.model.Region;
import com.amazonaws.services.s3.transfer.TransferManager;
import com.amazonaws.util.json.Jackson;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.File;

public class S3Link {
    private final S3ClientCache s3cc;
    private final ID id;

    S3Link(S3ClientCache s3cc, String bucketName, String key) {
        this(s3cc, new ID(bucketName, key));
    }

    S3Link(S3ClientCache s3cc, Region region, String bucketName, String key) {
        this(s3cc, new ID(region, bucketName, key));
    }

    private S3Link(S3ClientCache s3cc, ID id) {
        this.s3cc = s3cc;
        this.id = id;
        if (s3cc == null) {
            throw new IllegalArgumentException("S3ClientCache must be configured for use with S3Link");
        }
        if (id == null || id.getBucket() == null || id.getKey() == null) {
            throw new IllegalArgumentException("Bucket and key must be specified for S3Link");
        }
    }

    public String getKey() {
        return this.id.getKey();
    }

    public String getBucketName() {
        return this.id.getBucket();
    }

    public Region getS3Region() {
        return Region.fromValue(this.id.getRegionId());
    }

    String toJson() {
        return this.id.toJson();
    }

    static S3Link fromJson(S3ClientCache s3cc, String json) {
        ID id = Jackson.fromJsonString(json, ID.class);
        return new S3Link(s3cc, id);
    }

    public AmazonS3Client getAmazonS3Client() {
        return this.s3cc.getClient(this.getS3Region());
    }

    public TransferManager getTransferManager() {
        return this.s3cc.getTransferManager(this.getS3Region());
    }

    public PutObjectResult uploadFrom(File source) {
        return this.getAmazonS3Client().putObject(this.getBucketName(), this.getKey(), source);
    }

    public ObjectMetadata downloadTo(File destination) {
        return this.getAmazonS3Client().getObject(new GetObjectRequest(this.getBucketName(), this.getKey()), destination);
    }

    private static class S3 {
        @JsonProperty(value="region")
        private String regionId;
        @JsonProperty(value="bucket")
        private String bucket;
        @JsonProperty(value="key")
        private String key;

        S3() {
        }

        S3(String bucket, String key) {
            this(null, bucket, key);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        S3(Region region, String bucket, String key) {
            if (region == null) {
                if (!BucketNameUtils.isDNSBucketName(bucket)) throw new IllegalArgumentException("Region must be specified for bucket that cannot be addressed using virtual host style");
                this.regionId = Region.US_Standard.getFirstRegionId();
            } else {
                this.regionId = region.getFirstRegionId();
            }
            this.bucket = bucket;
            this.key = key;
        }

        @JsonProperty(value="bucket")
        public String getBucket() {
            return this.bucket;
        }

        @JsonProperty(value="key")
        public String getKey() {
            return this.key;
        }

        @JsonProperty(value="region")
        public String getRegionId() {
            return this.regionId;
        }
    }

    static class ID {
        @JsonProperty(value="s3")
        private S3 s3;

        ID() {
        }

        ID(String bucketName, String key) {
            this.s3 = new S3(bucketName, key);
        }

        ID(Region region, String bucketName, String key) {
            this.s3 = new S3(region, bucketName, key);
        }

        ID(S3 s3) {
            this.s3 = s3;
        }

        @JsonProperty(value="s3")
        public S3 getS3() {
            return this.s3;
        }

        @JsonIgnore
        public String getRegionId() {
            return this.s3.getRegionId();
        }

        @JsonIgnore
        public String getBucket() {
            return this.s3.getBucket();
        }

        @JsonIgnore
        public String getKey() {
            return this.s3.getKey();
        }

        String toJson() {
            return Jackson.toJsonString(this);
        }
    }
}

