/*
 * Decompiled with CFR 0.152.
 */
package org.htmlcleaner;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.StringTokenizer;
import org.htmlcleaner.BaseToken;
import org.htmlcleaner.CleanerProperties;
import org.htmlcleaner.CommentNode;
import org.htmlcleaner.ContentNode;
import org.htmlcleaner.Display;
import org.htmlcleaner.TagInfo;
import org.htmlcleaner.TagNode;
import org.htmlcleaner.XmlSerializer;

public class BrowserCompactXmlSerializer
extends XmlSerializer {
    private static final String PRE_TAG = "pre";
    private static final String BR_TAG = "<br />";
    private static final String LINE_BREAK = "\n";

    public BrowserCompactXmlSerializer(CleanerProperties props) {
        super(props);
    }

    protected void serialize(TagNode tagNode, Writer writer) throws IOException {
        this.serializeOpenTag(tagNode, writer, false);
        TagInfo tagInfo = this.props.getTagInfoProvider().getTagInfo(tagNode.getName());
        String tagName = tagInfo != null ? tagInfo.getName() : null;
        ArrayList tagChildren = new ArrayList(tagNode.getAllChildren());
        if (!this.isMinimizedTagSyntax(tagNode)) {
            ListIterator childrenIt = tagChildren.listIterator();
            while (childrenIt.hasNext()) {
                String content;
                Object item = childrenIt.next();
                if (item == null) continue;
                if (item instanceof ContentNode && !PRE_TAG.equals(tagName)) {
                    content = ((ContentNode)item).getContent();
                    content = this.dontEscape(tagNode) ? content.replaceAll("]]>", "]]&gt;") : this.escapeXml(content);
                    content = content.replaceAll("^\u00a0+", " ");
                    content = content.replaceAll("\u00a0+$", " ");
                    boolean whitespaceAllowed = tagInfo != null && tagInfo.getDisplay().isLeadingAndEndWhitespacesAllowed();
                    boolean writeLeadingSpace = content.length() > 0 && Character.isWhitespace(content.charAt(0)) && whitespaceAllowed;
                    boolean writeEndingSpace = content.length() > 1 && Character.isWhitespace(content.charAt(content.length() - 1)) && whitespaceAllowed;
                    if ((content = content.trim()).length() != 0) {
                        boolean hasPrevContent = false;
                        int order = tagChildren.indexOf(item);
                        if (order >= 2 && childrenIt.hasNext()) {
                            Object prev = tagChildren.get(order - 1);
                            hasPrevContent = this.isContentOrInline(prev);
                        }
                        if (writeLeadingSpace || hasPrevContent) {
                            writer.write(32);
                        }
                        StringTokenizer tokenizer = new StringTokenizer(content, LINE_BREAK, true);
                        String prevToken = "";
                        while (tokenizer.hasMoreTokens()) {
                            String token = tokenizer.nextToken();
                            if (prevToken.equals(token) && prevToken.equals(LINE_BREAK)) {
                                writer.write(BR_TAG);
                                prevToken = "";
                            } else if (LINE_BREAK.equals(token)) {
                                writer.write(32);
                            } else {
                                writer.write(token.trim());
                            }
                            prevToken = token;
                        }
                        boolean hasFollowingContent = false;
                        if (childrenIt.hasNext()) {
                            Object next = childrenIt.next();
                            hasFollowingContent = this.isContentOrInline(next);
                            childrenIt.previous();
                        }
                        if (!writeEndingSpace && !hasFollowingContent) continue;
                        writer.write(32);
                        continue;
                    }
                    childrenIt.remove();
                    continue;
                }
                if (item instanceof ContentNode) {
                    content = ((ContentNode)item).getContent();
                    writer.write(content);
                    continue;
                }
                if (item instanceof CommentNode) {
                    content = ((CommentNode)item).getCommentedContent().trim();
                    writer.write(content);
                    continue;
                }
                ((BaseToken)item).serialize(this, writer);
            }
            this.serializeEndTag(tagNode, writer, tagInfo != null && tagInfo.getDisplay().isAfterTagLineBreakNeeded());
        }
    }

    private boolean isContentOrInline(Object node) {
        boolean result = false;
        if (node instanceof ContentNode) {
            result = true;
        } else if (node instanceof TagNode) {
            TagInfo nextInfo = this.props.getTagInfoProvider().getTagInfo(((TagNode)node).getName());
            result = nextInfo != null && nextInfo.getDisplay() == Display.inline;
        }
        return result;
    }
}

