/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.stream.internal.classloading_utils;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.xml.stream.internal.classloading_utils.BundleClassLoader;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.service.packageadmin.PackageAdmin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OsgiEnvironmentClassLoader
extends ClassLoader
implements BundleListener {
    private final BundleContext bundleContext;
    private final ClassLoader supportingClassLoader;
    private final List<Bundle> bundles = new ArrayList<Bundle>();
    private final List<Bundle> prioritizedBundles = new ArrayList<Bundle>();
    private final Map<Bundle, BundleClassLoader> bundleClassLoaders = new HashMap<Bundle, BundleClassLoader>();

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Map<Bundle, BundleClassLoader> bundleClassLoaders = this.getBundleClassLoaders();
        for (Bundle bundle : this.getBundles()) {
            if (!this.canLoadResources(bundle) || !this.getPrioritizedBundles().contains(bundle) && !this.containsClassPackage(bundle, name)) continue;
            try {
                return bundleClassLoaders.get(bundle).loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.getSupportingClassLoader() != null) {
            return this.getSupportingClassLoader().loadClass(name);
        }
        throw new ClassNotFoundException(String.format("Class '%s' could not be load from %s", name, this.getClass().getSimpleName()));
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> clazz = this.findClass(name);
        if (resolve) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    @Override
    protected URL findResource(String name) {
        Map<Bundle, BundleClassLoader> bundleClassLoaders = this.getBundleClassLoaders();
        for (Bundle bundle : this.getBundles()) {
            if (!this.canLoadResources(bundle)) continue;
            try {
                URL resource = bundleClassLoaders.get(bundle).getResource(name);
                if (resource == null) continue;
                return resource;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.getSupportingClassLoader() != null) {
            return this.getSupportingClassLoader().getResource(name);
        }
        return null;
    }

    @Override
    public URL getResource(String name) {
        return this.findResource(name);
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        Vector<URL> resources = new Vector<URL>();
        Map<Bundle, BundleClassLoader> bundleClassLoaders = this.getBundleClassLoaders();
        for (Bundle bundle : this.getBundles()) {
            if (!this.canLoadResources(bundle)) continue;
            try {
                Enumeration<URL> bundleResources = bundleClassLoaders.get(bundle).getResources(name);
                if (bundleResources == null || !bundleResources.hasMoreElements()) continue;
                while (bundleResources.hasMoreElements()) {
                    resources.add(bundleResources.nextElement());
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (resources.size() > 0) {
            return resources.elements();
        }
        if (this.getSupportingClassLoader() != null) {
            return this.getSupportingClassLoader().getResources(name);
        }
        return new Vector().elements();
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        return this.findResources(name);
    }

    public void bundleChanged(BundleEvent bundleEvent) {
        if (bundleEvent.getType() == 1) {
            this.addBundle(bundleEvent.getBundle());
        } else if (bundleEvent.getType() == 16) {
            this.removeBundle(bundleEvent.getBundle());
        }
    }

    protected boolean canLoadResources(Bundle bundle) {
        return bundle.getState() != 1;
    }

    protected boolean containsClassPackage(Bundle bundle, String className) {
        return bundle.getEntry("/" + this.getPackageName(className)) != null || bundle.getEntry("/" + className.replace('.', '/') + ".class") != null;
    }

    protected String getPackageName(String className) {
        int lastDotIndex = className.lastIndexOf(46);
        return lastDotIndex >= 0 ? className.substring(0, lastDotIndex).replace('.', '/') : "";
    }

    public OsgiEnvironmentClassLoader(BundleContext bundleContext, ClassLoader parent, Class<?> ... prioritizedClasses) {
        this.bundleContext = bundleContext;
        this.supportingClassLoader = parent;
        this.initBundleClassLoaders(this.retrieveClassesBundles(prioritizedClasses));
        bundleContext.addBundleListener((BundleListener)this);
    }

    public OsgiEnvironmentClassLoader(BundleContext bundleContext, ClassLoader parent, Bundle ... prioritizedBundles) {
        this.bundleContext = bundleContext;
        this.supportingClassLoader = parent;
        this.initBundleClassLoaders(prioritizedBundles);
        bundleContext.addBundleListener((BundleListener)this);
    }

    protected void initBundleClassLoaders(Bundle ... priorityBundles) {
        this.getPrioritizedBundles().addAll((Collection<Bundle>)Arrays.asList(priorityBundles));
        this.addBundles(priorityBundles);
        this.addBundles(this.getBundleContext().getBundles());
    }

    protected void addBundles(Bundle ... bundles) {
        Bundle systemBundle = null;
        Bundle[] bundleArray = bundles;
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            if (!this.getBundleClassLoaders().containsKey(bundle)) {
                if (bundle.getBundleId() != 0L) {
                    this.addBundle(bundle);
                } else {
                    systemBundle = bundle;
                }
            }
            ++n2;
        }
        if (systemBundle != null) {
            this.addBundle(systemBundle);
        }
    }

    protected synchronized void addBundle(Bundle bundle) {
        this.getBundles().add(bundle);
        this.getBundleClassLoaders().put(bundle, new BundleClassLoader(bundle));
    }

    protected synchronized void removeBundle(Bundle bundle) {
        this.getBundles().remove(bundle);
        this.getBundleClassLoaders().remove(bundle);
    }

    protected Bundle[] retrieveClassesBundles(Class<?> ... classes) {
        PackageAdmin packageAdmin = (PackageAdmin)this.getBundleContext().getService(this.getBundleContext().getServiceReference(PackageAdmin.class.getName()));
        ArrayList<Bundle> priorityBundles = new ArrayList<Bundle>();
        Class<?>[] classArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> priorityClass = classArray[n2];
            priorityBundles.add(packageAdmin.getBundle(priorityClass));
            ++n2;
        }
        return priorityBundles.toArray(new Bundle[0]);
    }

    protected BundleContext getBundleContext() {
        return this.bundleContext;
    }

    protected ClassLoader getSupportingClassLoader() {
        return this.supportingClassLoader;
    }

    protected List<Bundle> getBundles() {
        return this.bundles;
    }

    protected List<Bundle> getPrioritizedBundles() {
        return this.prioritizedBundles;
    }

    protected Map<Bundle, BundleClassLoader> getBundleClassLoaders() {
        return this.bundleClassLoaders;
    }
}

