/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.monitor;

import com.hazelcast.impl.monitor.LocalMapOperationStatsImpl;
import com.hazelcast.impl.monitor.LocalOperationStatsSupport;
import com.hazelcast.impl.monitor.OperationsCounterSupport;
import com.hazelcast.monitor.LocalMapOperationStats;
import java.util.concurrent.atomic.AtomicLong;

public class MapOperationsCounter
extends OperationsCounterSupport<LocalMapOperationStats> {
    private static final LocalMapOperationStats empty = new LocalMapOperationStatsImpl();
    private final OperationsCounterSupport.OperationCounter puts = new OperationsCounterSupport.OperationCounter(this);
    private final OperationsCounterSupport.OperationCounter gets = new OperationsCounterSupport.OperationCounter(this);
    private final OperationsCounterSupport.OperationCounter removes = new OperationsCounterSupport.OperationCounter(this);
    private final AtomicLong others = new AtomicLong();
    private final AtomicLong events = new AtomicLong();

    public MapOperationsCounter() {
    }

    public MapOperationsCounter(long interval) {
        super(interval);
    }

    MapOperationsCounter getAndReset() {
        OperationsCounterSupport.OperationCounter putsNow = this.puts.copyAndReset();
        OperationsCounterSupport.OperationCounter getsNow = this.gets.copyAndReset();
        OperationsCounterSupport.OperationCounter removesNow = this.removes.copyAndReset();
        long othersNow = this.others.getAndSet(0L);
        long eventsNow = this.events.getAndSet(0L);
        MapOperationsCounter newOne = new MapOperationsCounter();
        newOne.puts.set(putsNow);
        newOne.gets.set(getsNow);
        newOne.removes.set(removesNow);
        newOne.others.set(othersNow);
        newOne.events.set(eventsNow);
        newOne.startTime = this.startTime;
        this.startTime = newOne.endTime = this.now();
        return newOne;
    }

    public void incrementPuts(long elapsed) {
        this.puts.count(elapsed);
        this.publishSubResult();
    }

    public void incrementGets(long elapsed) {
        this.gets.count(elapsed);
        this.publishSubResult();
    }

    public void incrementRemoves(long elapsed) {
        this.removes.count(elapsed);
        this.publishSubResult();
    }

    public void incrementOtherOperations() {
        this.others.incrementAndGet();
        this.publishSubResult();
    }

    public void incrementReceivedEvents() {
        this.events.incrementAndGet();
        this.publishSubResult();
    }

    @Override
    LocalMapOperationStats aggregateSubCounterStats() {
        LocalMapOperationStatsImpl stats = new LocalMapOperationStatsImpl();
        stats.periodStart = ((MapOperationsCounter)this.listOfSubCounters.get((int)0)).startTime;
        int i = 0;
        while (i < this.listOfSubCounters.size()) {
            MapOperationsCounter sub = (MapOperationsCounter)this.listOfSubCounters.get(i);
            stats.gets.add(sub.gets.count.get(), sub.gets.totalLatency.get());
            stats.puts.add(sub.puts.count.get(), sub.puts.totalLatency.get());
            stats.removes.add(sub.removes.count.get(), sub.removes.totalLatency.get());
            stats.numberOfOtherOperations += sub.others.get();
            stats.numberOfEvents += sub.events.get();
            stats.periodEnd = sub.endTime;
            ++i;
        }
        return stats;
    }

    @Override
    LocalMapOperationStats getThis() {
        LocalMapOperationStatsImpl stats = new LocalMapOperationStatsImpl();
        stats.periodStart = this.startTime;
        LocalMapOperationStatsImpl localMapOperationStatsImpl = stats;
        localMapOperationStatsImpl.getClass();
        stats.gets = new LocalOperationStatsSupport.OperationStat(localMapOperationStatsImpl, this.gets.count.get(), this.gets.totalLatency.get());
        LocalMapOperationStatsImpl localMapOperationStatsImpl2 = stats;
        localMapOperationStatsImpl2.getClass();
        stats.puts = new LocalOperationStatsSupport.OperationStat(localMapOperationStatsImpl2, this.puts.count.get(), this.puts.totalLatency.get());
        LocalMapOperationStatsImpl localMapOperationStatsImpl3 = stats;
        localMapOperationStatsImpl3.getClass();
        stats.removes = new LocalOperationStatsSupport.OperationStat(localMapOperationStatsImpl3, this.removes.count.get(), this.removes.totalLatency.get());
        stats.numberOfEvents = this.events.get();
        stats.periodEnd = this.now();
        return stats;
    }

    @Override
    LocalMapOperationStats getEmpty() {
        return empty;
    }

    public String toString() {
        return "MapOperationsCounter{empty=" + empty + ", puts=" + this.puts + ", gets=" + this.gets + ", removes=" + this.removes + ", others=" + this.others + ", events=" + this.events + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", published=" + this.published + ", listOfSubStats=" + this.listOfSubCounters + ", lock=" + this.lock + ", interval=" + this.interval + '}';
    }
}

