/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.propertyeditors;

import java.beans.PropertyEditorSupport;
import org.springframework.util.StringUtils;

public class CharacterEditor
extends PropertyEditorSupport {
    private final boolean allowEmpty;

    public CharacterEditor(boolean allowEmpty) {
        this.allowEmpty = allowEmpty;
    }

    public void setAsText(String text) throws IllegalArgumentException {
        if (this.allowEmpty && !StringUtils.hasText((String)text)) {
            this.setValue(null);
        } else {
            if (text.length() != 1) {
                throw new IllegalArgumentException("String [" + text + "] with length " + text.length() + " cannot be converted to char type");
            }
            this.setValue(new Character(text.charAt(0)));
        }
    }

    public String getAsText() {
        Object value = this.getValue();
        return value != null ? value.toString() : "";
    }
}

