/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cluster;

import com.hazelcast.core.Cluster;
import com.hazelcast.core.InitialMembershipEvent;
import com.hazelcast.core.InitialMembershipListener;
import com.hazelcast.core.Member;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import com.hazelcast.impl.MemberImpl;
import com.hazelcast.impl.NamedExecutorService;
import com.hazelcast.impl.Node;
import com.hazelcast.nio.Address;
import com.hazelcast.util.Clock;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicReference;

public class ClusterImpl
implements Cluster {
    final CopyOnWriteArraySet<MembershipListener> listeners = new CopyOnWriteArraySet();
    final AtomicReference<Set<MemberImpl>> members = new AtomicReference<Set>(Collections.EMPTY_SET);
    final AtomicReference<MemberImpl> localMember = new AtomicReference();
    final Map<Address, MemberImpl> memberAddressMap = new ConcurrentHashMap<Address, MemberImpl>();
    final Map<MemberImpl, MemberImpl> memberMap = new ConcurrentHashMap<MemberImpl, MemberImpl>();
    volatile long clusterTimeDiff = Long.MAX_VALUE;
    final Node node;
    final Object memberChangeMutex = new Object();

    public ClusterImpl(Node node) {
        this.node = node;
        this.reset();
    }

    public void reset() {
        this.setMembers(Arrays.asList(this.node.getLocalMember()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMembers(List<MemberImpl> incomingMembers) {
        LinkedHashSet<MemberImpl> newMembers = new LinkedHashSet<MemberImpl>(incomingMembers.size());
        Set<MemberImpl> oldMembers = this.members.get();
        LinkedList<MemberImpl> addedMembers = new LinkedList<MemberImpl>();
        LinkedList<MemberImpl> removedMembers = new LinkedList<MemberImpl>();
        for (MemberImpl incomingMember : incomingMembers) {
            MemberImpl member = this.memberMap.get(incomingMember);
            if (member == null) {
                member = incomingMember;
                addedMembers.add(member);
                this.memberMap.put(member, member);
                this.memberAddressMap.put(member.getAddress(), member);
            }
            if (member.localMember()) {
                this.localMember.set(member);
            }
            newMembers.add(member);
        }
        for (MemberImpl oldMember : oldMembers) {
            if (newMembers.contains(oldMember)) continue;
            removedMembers.add(oldMember);
            this.memberMap.remove(oldMember);
            this.memberAddressMap.remove(oldMember.getAddress());
        }
        Object object = this.memberChangeMutex;
        synchronized (object) {
            MembershipEvent event;
            this.members.set(Collections.unmodifiableSet(newMembers));
            if (this.listeners.isEmpty()) {
                return;
            }
            LinkedHashSet<MemberImpl> membersAfterEvent = new LinkedHashSet<MemberImpl>(oldMembers);
            NamedExecutorService eventExecutor = this.node.executorManager.getEventExecutorService();
            for (Member member : addedMembers) {
                membersAfterEvent.add((MemberImpl)member);
                event = new MembershipEvent(this, member, 1, Collections.unmodifiableSet(new LinkedHashSet<MemberImpl>(membersAfterEvent)));
                for (final MembershipListener listener : this.listeners) {
                    eventExecutor.executeOrderedRunnable(listener.hashCode(), new Runnable(){

                        @Override
                        public void run() {
                            listener.memberAdded(event);
                        }
                    });
                }
            }
            for (Member member : removedMembers) {
                membersAfterEvent.remove(member);
                event = new MembershipEvent(this, member, 3, Collections.unmodifiableSet(new LinkedHashSet<MemberImpl>(membersAfterEvent)));
                for (final MembershipListener listener : this.listeners) {
                    eventExecutor.executeOrderedRunnable(listener.hashCode(), new Runnable(){

                        @Override
                        public void run() {
                            listener.memberRemoved(event);
                        }
                    });
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMembershipListener(MembershipListener listener) {
        if (!(listener instanceof InitialMembershipListener)) {
            this.listeners.add(listener);
        } else {
            Object object = this.memberChangeMutex;
            synchronized (object) {
                if (!this.listeners.add(listener)) {
                    return;
                }
                final InitialMembershipListener initializingListener = (InitialMembershipListener)listener;
                final InitialMembershipEvent event = new InitialMembershipEvent(this, this.getMembers());
                this.node.executorManager.getEventExecutorService().executeOrderedRunnable(listener.hashCode(), new Runnable(){

                    @Override
                    public void run() {
                        initializingListener.init(event);
                    }
                });
            }
        }
    }

    @Override
    public void removeMembershipListener(MembershipListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public Member getLocalMember() {
        return this.localMember.get();
    }

    @Override
    public Set<Member> getMembers() {
        return this.members.get();
    }

    @Override
    public long getClusterTime() {
        return Clock.currentTimeMillis() + (this.clusterTimeDiff == Long.MAX_VALUE ? 0L : this.clusterTimeDiff);
    }

    public void setMasterTime(long masterTime) {
        long diff = masterTime - Clock.currentTimeMillis();
        if (Math.abs(diff) < Math.abs(this.clusterTimeDiff)) {
            this.clusterTimeDiff = diff;
        }
    }

    public long getClusterTimeFor(long localTime) {
        return localTime + (this.clusterTimeDiff == Long.MAX_VALUE ? 0L : this.clusterTimeDiff);
    }

    public Member getMember(Address address) {
        return this.memberAddressMap.get(address);
    }

    public String toString() {
        Set<Member> members = this.getMembers();
        StringBuffer sb = new StringBuffer("Cluster [");
        if (members != null) {
            sb.append(members.size());
            sb.append("] {");
            for (Member member : members) {
                sb.append("\n\t").append(member);
            }
        }
        sb.append("\n}\n");
        return sb.toString();
    }

    private static class Notification
    implements Runnable {
        private final MembershipListener listener;
        private final MembershipEvent event;

        private Notification(MembershipEvent event, MembershipListener listener) {
            this.event = event;
            this.listener = listener;
        }

        @Override
        public void run() {
            switch (this.event.getEventType()) {
                case 1: {
                    this.listener.memberAdded(this.event);
                    break;
                }
                case 3: {
                    this.listener.memberRemoved(this.event);
                    break;
                }
                default: {
                    throw new RuntimeException("Unhandeled event: " + this.event);
                }
            }
        }
    }
}

