/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.jmx;

import java.util.Arrays;
import java.util.Collection;
import org.javasimon.Counter;
import org.javasimon.CounterSample;
import org.javasimon.Manager;
import org.javasimon.Simon;
import org.javasimon.SimonState;
import org.javasimon.Stopwatch;
import org.javasimon.StopwatchSample;
import org.javasimon.jmx.SimonInfo;
import org.javasimon.jmx.SimonManagerMXBean;
import org.javasimon.utils.SimonUtils;

public class SimonManagerMXBeanImpl
implements SimonManagerMXBean {
    private Manager manager;

    public SimonManagerMXBeanImpl(Manager manager) {
        this.manager = manager;
    }

    public final void enable() {
        this.manager.enable();
    }

    public final void disable() {
        this.manager.disable();
    }

    public final boolean isEnabled() {
        return this.manager.isEnabled();
    }

    public final String[] getSimonNames() {
        Collection<String> simonNames = this.manager.getSimonNames();
        return simonNames.toArray(new String[simonNames.size()]);
    }

    public final String[] getSimonNamesOrdered() {
        Object[] simonNames = this.getSimonNames();
        Arrays.sort(simonNames);
        return simonNames;
    }

    public final String getType(String name) {
        Simon s = this.manager.getSimon(name);
        return s != null ? (s instanceof Stopwatch ? "Stopwatch" : "Counter") : null;
    }

    public final SimonInfo[] getSimonInfos() {
        String[] simonNames = this.getSimonNamesOrdered();
        SimonInfo[] simonInfo = new SimonInfo[simonNames.length];
        int i = 0;
        for (String name : simonNames) {
            Simon s = this.manager.getSimon(name);
            simonInfo[i++] = new SimonInfo(name, s instanceof Stopwatch ? "Stopwatch" : (s instanceof Counter ? "Counter" : "Unknown"));
        }
        return simonInfo;
    }

    public final void clear() {
        this.manager.clear();
    }

    public final void enableSimon(String name) {
        this.manager.getSimon(name).setState(SimonState.ENABLED, false);
    }

    public final void disableSimon(String name) {
        this.manager.getSimon(name).setState(SimonState.DISABLED, false);
    }

    public final void inheritState(String name) {
        this.manager.getSimon(name).setState(SimonState.INHERIT, false);
    }

    public final org.javasimon.jmx.CounterSample getCounterSample(String name) {
        Simon s = this.manager.getSimon(name);
        if (s != null && s instanceof Counter) {
            return new org.javasimon.jmx.CounterSample((CounterSample)s.sample());
        }
        return null;
    }

    public final org.javasimon.jmx.StopwatchSample getStopwatchSample(String name) {
        Simon s = this.manager.getSimon(name);
        if (s != null && s instanceof Stopwatch) {
            return new org.javasimon.jmx.StopwatchSample((StopwatchSample)s.sample());
        }
        return null;
    }

    public final org.javasimon.jmx.CounterSample getCounterSampleAndReset(String name) {
        Simon s = this.manager.getSimon(name);
        if (s != null && s instanceof Counter) {
            return new org.javasimon.jmx.CounterSample((CounterSample)s.sampleAndReset());
        }
        return null;
    }

    public final org.javasimon.jmx.StopwatchSample getStopwatchSampleAndReset(String name) {
        Simon s = this.manager.getSimon(name);
        if (s != null && s instanceof Stopwatch) {
            return new org.javasimon.jmx.StopwatchSample((StopwatchSample)s.sampleAndReset());
        }
        return null;
    }

    public final void printSimonTree() {
        System.out.println(SimonUtils.simonTreeString(this.manager.getRootSimon()));
    }

    public final void reset(String name) {
        this.manager.getSimon(name).reset();
    }
}

