/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon;

import org.javasimon.SimonException;
import org.javasimon.utils.SimonUtils;

public final class SimonPattern {
    private static final String WILDCARD_STAR = "*";
    private String pattern;
    private String all;
    private String start;
    private String end;
    private String middle;
    private static final String INVALID_PATTERN = "Invalid Simon pattern: ";

    public static SimonPattern create(String pattern) {
        if (pattern == null) {
            return null;
        }
        return new SimonPattern(pattern);
    }

    public SimonPattern(String pattern) {
        this.pattern = pattern;
        if (!pattern.contains(WILDCARD_STAR)) {
            this.all = pattern;
            if (!SimonUtils.checkName(this.all)) {
                throw new SimonException(INVALID_PATTERN + pattern);
            }
            return;
        }
        if (pattern.equals(WILDCARD_STAR)) {
            this.middle = "";
            return;
        }
        if (pattern.startsWith(WILDCARD_STAR) && pattern.endsWith(WILDCARD_STAR) && pattern.length() > 2) {
            this.middle = pattern.substring(1, pattern.length() - 2);
            if (!SimonUtils.checkName(this.middle)) {
                throw new SimonException(INVALID_PATTERN + pattern);
            }
            return;
        }
        int ix = pattern.lastIndexOf(42);
        if (ix != pattern.indexOf(42)) {
            throw new SimonException(INVALID_PATTERN + pattern);
        }
        if (!pattern.endsWith(WILDCARD_STAR)) {
            this.end = pattern.substring(ix + 1);
            if (!SimonUtils.checkName(this.end)) {
                throw new SimonException(INVALID_PATTERN + pattern);
            }
        }
        if (!pattern.startsWith(WILDCARD_STAR)) {
            this.start = pattern.substring(0, ix);
            if (!SimonUtils.checkName(this.start)) {
                throw new SimonException(INVALID_PATTERN + pattern);
            }
        }
    }

    public boolean matches(String name) {
        if (name == null) {
            return this.pattern.equals("");
        }
        if (this.all != null) {
            return this.all.equals(name);
        }
        if (this.middle != null) {
            return name.contains(this.middle);
        }
        if (this.start != null && !name.startsWith(this.start)) {
            return false;
        }
        return this.end == null || name.endsWith(this.end);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimonPattern that = (SimonPattern)o;
        return !(this.pattern == null ? that.pattern != null : !this.pattern.equals(that.pattern));
    }

    public int hashCode() {
        return this.pattern != null ? this.pattern.hashCode() : 0;
    }

    public String toString() {
        return "ConfigPattern: " + this.pattern;
    }
}

