/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jooreports.templates;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import net.sf.jooreports.opendocument.OpenDocumentArchive;
import net.sf.jooreports.templates.Configuration;
import net.sf.jooreports.templates.DocumentTemplate;
import net.sf.jooreports.templates.DocumentTemplateException;
import net.sf.jooreports.templates.xmlfilters.DynamicImageFilter;
import net.sf.jooreports.templates.xmlfilters.ScriptTagFilter;
import net.sf.jooreports.templates.xmlfilters.TextInputTagFilter;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.ParsingException;
import nu.xom.Serializer;
import org.apache.commons.io.output.ByteArrayOutputStream;

class TemplatePreProcessor {
    private static final String UTF_8 = "UTF-8";
    private String[] xmlEntries;
    private DocumentTemplate.ContentWrapper contentWrapper;
    private final Map configurations;
    private final TextInputTagFilter textInputTagFilter = new TextInputTagFilter();
    private final ScriptTagFilter scriptTagFilter = new ScriptTagFilter();
    private final DynamicImageFilter dynamicImageFilter = new DynamicImageFilter();

    public TemplatePreProcessor(String[] xmlEntries, DocumentTemplate.ContentWrapper contentWrapper, Map configurations) {
        this.xmlEntries = xmlEntries;
        this.contentWrapper = contentWrapper;
        this.configurations = configurations;
    }

    public void process(OpenDocumentArchive archive) throws DocumentTemplateException, IOException {
        Iterator it = archive.getEntryNames().iterator();
        while (it.hasNext()) {
            String entryName = (String)it.next();
            if (Arrays.binarySearch(this.xmlEntries, entryName) < 0) continue;
            InputStream inputStream = archive.getEntryInputStream(entryName);
            OutputStream outputStream = archive.getEntryOutputStream(entryName);
            this.applyXmlFilters(inputStream, outputStream);
            inputStream.close();
            outputStream.close();
        }
    }

    private void applyXmlFilters(InputStream input, OutputStream output) throws DocumentTemplateException, IOException {
        Builder builder = new Builder();
        Document document = null;
        try {
            document = builder.build(input);
        }
        catch (ParsingException parsingException) {
            throw new DocumentTemplateException(parsingException);
        }
        Boolean setting = Configuration.getConfiguration("process_jooscript_only", this.configurations);
        if (setting != null) {
            this.textInputTagFilter.setProcessJooScriptOnly(setting);
        }
        this.textInputTagFilter.doFilter(document);
        this.scriptTagFilter.doFilter(document);
        this.dynamicImageFilter.doFilter(document);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Serializer serializer = new Serializer((OutputStream)byteArrayOutputStream, UTF_8);
        serializer.write(document);
        output.write(this.contentWrapper.wrapContent(byteArrayOutputStream.toString(UTF_8)).getBytes(UTF_8));
    }
}

