/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes.sampleentry;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.ContainerBox;
import com.coremedia.iso.boxes.sampleentry.SampleEntry;
import java.io.IOException;
import java.util.Arrays;

public class MpegSampleEntry
extends SampleEntry
implements ContainerBox {
    public MpegSampleEntry(byte[] type) {
        super(type);
    }

    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        super.parse(in, size, boxParser, lastMovieFragmentBox);
        while (size > 8L) {
            Box b = boxParser.parseBox(in, this, lastMovieFragmentBox);
            this.boxes.add(b);
            size -= b.getSize();
        }
    }

    protected long getContentSize() {
        long contentSize = 8L;
        for (Box boxe : this.boxes) {
            contentSize += boxe.getSize();
        }
        return contentSize;
    }

    public String toString() {
        return "MpegSampleEntry" + Arrays.asList(this.getBoxes());
    }

    protected void getContent(IsoOutputStream isos) throws IOException {
        isos.write(new byte[6]);
        isos.writeUInt16(this.getDataReferenceIndex());
        for (Box boxe : this.boxes) {
            boxe.getBox(isos);
        }
    }
}

