/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.ChunkOffsetBox;
import java.io.IOException;

public class ChunkOffset64BitBox
extends ChunkOffsetBox {
    public static final String TYPE = "co64";
    private long[] chunkOffsets;

    public ChunkOffset64BitBox() {
        super(TYPE);
    }

    public long[] getChunkOffsets() {
        return this.chunkOffsets;
    }

    protected long getContentSize() {
        return 4 + 8 * this.chunkOffsets.length;
    }

    protected void getContent(IsoOutputStream os) throws IOException {
        long[] chunkOffsets = this.getChunkOffsets();
        os.writeUInt32(chunkOffsets.length);
        for (long chunkOffet : chunkOffsets) {
            os.writeUInt64(chunkOffet);
        }
    }

    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        super.parse(in, size, boxParser, lastMovieFragmentBox);
        long entryCount = in.readUInt32();
        if (entryCount > Integer.MAX_VALUE) {
            throw new IOException("The parser cannot deal with more than Integer.MAX_VALUE entries!");
        }
        this.chunkOffsets = new long[(int)entryCount];
        int i = 0;
        while ((long)i < entryCount) {
            this.chunkOffsets[i] = in.readUInt64();
            ++i;
        }
    }
}

