/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.corba.common.idltypes;

import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.cxf.tools.corba.common.idltypes.IdlAnonArray;
import org.apache.cxf.tools.corba.common.idltypes.IdlDefnImplBase;
import org.apache.cxf.tools.corba.common.idltypes.IdlScopeBase;
import org.apache.cxf.tools.corba.common.idltypes.IdlType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdlArrayBase
extends IdlDefnImplBase
implements IdlType {
    private IdlType elemType;
    private List<Object> dims;
    private int size;

    protected IdlArrayBase(IdlScopeBase parent, String name, IdlType elem, int length) {
        super(parent, name);
        this.size = length;
        this.dims = new Vector<Object>();
        if (elem instanceof IdlAnonArray) {
            IdlAnonArray arr = (IdlAnonArray)elem;
            this.elemType = arr.elemType();
            Iterator it = arr.dimensions().iterator();
            while (it.hasNext()) {
                this.dims.add(it.next());
            }
        } else {
            this.elemType = elem;
        }
        this.dims.add(0, new Integer(this.size));
    }

    @Override
    public void write(PrintWriter pw) {
        Iterator<Object> it = this.dims.iterator();
        while (it.hasNext()) {
            pw.print("[" + it.next() + "]");
        }
    }

    @Override
    public void write(PrintWriter pw, String name) {
        pw.print(name);
        Iterator<Object> it = this.dims.iterator();
        while (it.hasNext()) {
            pw.print("[" + it.next() + "]");
        }
    }

    @Override
    public boolean isEmptyDef() {
        return this.elemType.isEmptyDef();
    }

    @Override
    public IdlScopeBase getCircularScope(IdlScopeBase startScope, List<Object> doneDefn) {
        return this.elemType.getCircularScope(startScope, doneDefn);
    }

    IdlType elemType() {
        return this.elemType;
    }

    int size() {
        return this.size;
    }

    protected List dimensions() {
        return this.dims;
    }
}

