/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2012 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.smtp;

import com.openexchange.i18n.LocalizableStrings;

/**
 * {@link SMTPExceptionMessage}
 *
 * @author <a href="mailto:jan.bauerdick@open-xchange.com">Jan Bauerdick</a>
 */
public class SMTPExceptionMessage implements LocalizableStrings {

    /**
     * Initializes a new {@link SMTPExceptionMessage}.
     */
    private SMTPExceptionMessage() {
        super();
    }

    /**
     * The message part with sequence ID %1$s could not be found in message %2$s in folder %3$s
     */
    public final static String PART_NOT_FOUND_MSG = "The message part with sequence ID %1$s could not be found in message %2$s in folder %3$s";

    /**
     * Html-2-Text conversion failed: %1$s
     */
    public final static String HTML2TEXT_CONVERTER_ERROR_MSG = "Html-2-Text conversion failed: %1$s";

    /**
     * An internal error occurred: %1$s
     */
    public final static String INTERNAL_ERROR_MSG = "An internal error occurred: %1$s";

    /**
     * No recipient(s) has been defined for new message
     */
    public final static String MISSING_RECIPIENTS_MSG = "There are no recipient(s) for the new message.";

    /**
     * Receipt acknowledgment cannot be sent: missing header %1$s in message %2$s
     */
    public final static String MISSING_NOTIFICATION_HEADER_MSG = "Receipt acknowledgment cannot be sent: missing header %1$s in message %2$s";

    /**
     * No send address could be found in user configuration
     */
    public final static String NO_SEND_ADDRESS_FOUND_MSG = "No send address could be found in user configuration";

    /**
     * No content available in mail part
     */
    public final static String NO_CONTENT_MSG = "No content available in mail part";

    /**
     * No storage access because mail connection is not connected
     */
    public final static String NOT_CONNECTED_MSG = "No storage access because mail connection is not connected";

    // Unable to parse SMTP server URI "%1$s".
    public final static String URI_PARSE_FAILED_MSG = "Unable to parse SMTP server URI \"%1$s\".";

    // The following recipient is not allowed: %1$s. Please remove associated address and try again.
    public static final String RECIPIENT_NOT_ALLOWED = "The following recipient is not allowed: %1$s. Please remove associated address and try again.";

}
