/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.console.plugin;

import java.io.IOException;
import org.javasimon.Simon;
import org.javasimon.Stopwatch;
import org.javasimon.callback.calltree.CallTree;
import org.javasimon.callback.calltree.CallTreeCallback;
import org.javasimon.callback.calltree.CallTreeNode;
import org.javasimon.console.ActionContext;
import org.javasimon.console.SimonCallbacks;
import org.javasimon.console.action.DetailHtmlBuilder;
import org.javasimon.console.action.DetailPlugin;
import org.javasimon.console.html.HtmlResourceType;
import org.javasimon.console.json.ArrayJS;
import org.javasimon.console.json.ObjectJS;
import org.javasimon.console.text.StringifierFactory;

public class CallTreeDetailPlugin
extends DetailPlugin {
    public static final String NO_CALLBACK_MESSAGE = "CallTree callback not registered";
    private static final String NO_DATA_MESSAGE = "No call tree available yet";

    public CallTreeDetailPlugin() {
        super("callTree", "Call Tree");
        this.addResource("js/javasimon-callTreePlugin.js", HtmlResourceType.JS);
        this.addResource("js/javasimon-dataTreeTable.js", HtmlResourceType.JS);
    }

    public boolean supports(Simon simon) {
        return simon instanceof Stopwatch;
    }

    private boolean isCallTreeCallbackRegistered(ActionContext context) {
        return SimonCallbacks.getCallbackByType(context.getManager(), CallTreeCallback.class) != null;
    }

    private CallTree getData(Simon simon) {
        return CallTreeCallback.getLastCallTree((Stopwatch)((Stopwatch)simon));
    }

    private void htmlMessage(DetailHtmlBuilder htmlBuilder, String message) throws IOException {
        htmlBuilder.beginRow().labelCell("Message").valueCell(" colspan=\"3\"", message).endRow();
    }

    private DetailHtmlBuilder htmlTreeNode(CallTreeNode node, DetailHtmlBuilder htmlBuilder, StringifierFactory htmlStringifierFactory) throws IOException {
        ((DetailHtmlBuilder)((DetailHtmlBuilder)htmlBuilder.begin("li")).text(node.getName())).text(":&nbsp;");
        if (node.getParent() != null) {
            ((DetailHtmlBuilder)((DetailHtmlBuilder)htmlBuilder.text(htmlStringifierFactory.toString(node.getPercent()))).text("%")).text(", ");
        }
        ((DetailHtmlBuilder)((DetailHtmlBuilder)((DetailHtmlBuilder)((DetailHtmlBuilder)htmlBuilder.text("total&nbsp;")).text(htmlStringifierFactory.toString(node.getTotal(), "Time"))).text(", ")).text("count&nbsp;")).text(htmlStringifierFactory.toString(node.getSplitCount()));
        if (!node.getChildren().isEmpty()) {
            htmlBuilder.begin("ul");
            for (CallTreeNode childNode : node.getChildren()) {
                this.htmlTreeNode(childNode, htmlBuilder, htmlStringifierFactory);
            }
            htmlBuilder.end("ul");
        }
        return (DetailHtmlBuilder)htmlBuilder.end("li");
    }

    public DetailHtmlBuilder executeHtml(ActionContext context, DetailHtmlBuilder htmlBuilder, StringifierFactory htmlStringifierFactory, Simon simon) throws IOException {
        if (this.isCallTreeCallbackRegistered(context)) {
            CallTree callTree = this.getData(simon);
            if (callTree == null) {
                this.htmlMessage(htmlBuilder, NO_DATA_MESSAGE);
            } else {
                htmlBuilder.beginRow().labelCell("Threshold").valueCell(htmlStringifierFactory.toString(callTree.getLogThreshold(), "Time")).endRow().beginRow().labelCell("Tree").beginValueCell().begin("ul");
                ((DetailHtmlBuilder)this.htmlTreeNode(callTree.getRootNode(), htmlBuilder, htmlStringifierFactory).end("ul")).endValueCell().endRow();
            }
        } else {
            this.htmlMessage(htmlBuilder, NO_CALLBACK_MESSAGE);
        }
        return htmlBuilder;
    }

    private ObjectJS jsonMessage(String message, StringifierFactory jsonStringifierFactory) {
        ObjectJS callTreeJS = new ObjectJS();
        callTreeJS.setSimpleAttribute("message", message, jsonStringifierFactory.getStringifier(String.class));
        return callTreeJS;
    }

    private ObjectJS jsonTreeNode(CallTreeNode node, StringifierFactory jsonStringifierFactory) {
        ObjectJS nodeJS = ObjectJS.create(node, jsonStringifierFactory);
        if (!node.getChildren().isEmpty()) {
            ArrayJS childNodesJS = new ArrayJS(node.getChildren().size());
            for (CallTreeNode childNode : node.getChildren()) {
                childNodesJS.addElement(this.jsonTreeNode(childNode, jsonStringifierFactory));
            }
            nodeJS.setAttribute("children", childNodesJS);
        }
        return nodeJS;
    }

    public ObjectJS executeJson(ActionContext context, StringifierFactory jsonStringifierFactory, Simon simon) {
        ObjectJS callTreeJS;
        if (this.isCallTreeCallbackRegistered(context)) {
            CallTree callTree = this.getData(simon);
            if (callTree == null) {
                callTreeJS = this.jsonMessage(NO_DATA_MESSAGE, jsonStringifierFactory);
            } else {
                callTreeJS = ObjectJS.create(callTree, jsonStringifierFactory);
                callTreeJS.setAttribute("rootNode", this.jsonTreeNode(callTree.getRootNode(), jsonStringifierFactory));
            }
        } else {
            callTreeJS = this.jsonMessage(NO_CALLBACK_MESSAGE, jsonStringifierFactory);
        }
        return callTreeJS;
    }
}

