/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.connection;

import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xsocket.DataConverter;
import org.xsocket.Execution;
import org.xsocket.ILifeCycle;
import org.xsocket.MaxReadSizeExceededException;
import org.xsocket.SerializedTaskQueue;
import org.xsocket.connection.ConnectionUtils;
import org.xsocket.connection.IConnectExceptionHandler;
import org.xsocket.connection.IConnectHandler;
import org.xsocket.connection.IConnectionScoped;
import org.xsocket.connection.IConnectionTimeoutHandler;
import org.xsocket.connection.IDataHandler;
import org.xsocket.connection.IDisconnectHandler;
import org.xsocket.connection.IHandler;
import org.xsocket.connection.IHandlerInfo;
import org.xsocket.connection.IIdleTimeoutHandler;
import org.xsocket.connection.INonBlockingConnection;

class HandlerAdapter {
    private static final Logger LOG = Logger.getLogger(HandlerAdapter.class.getName());
    private static final IHandler NULL_HANDLER = new NullHandler();
    private static final HandlerAdapter NULL_HANDLER_ADAPTER = new HandlerAdapter(NULL_HANDLER, ConnectionUtils.getHandlerInfo(NULL_HANDLER));
    private final IHandler handler;
    private final IHandlerInfo handlerInfo;

    HandlerAdapter(IHandler handler, IHandlerInfo handlerInfo) {
        this.handler = handler;
        this.handlerInfo = handlerInfo;
    }

    static HandlerAdapter newInstance(IHandler handler) {
        if (handler == null) {
            return NULL_HANDLER_ADAPTER;
        }
        IHandlerInfo handlerInfo = ConnectionUtils.getHandlerInfo(handler);
        return new HandlerAdapter(handler, handlerInfo);
    }

    final IHandler getHandler() {
        return this.handler;
    }

    final IHandlerInfo getHandlerInfo() {
        return this.handlerInfo;
    }

    private String printHandler() {
        return this.handler.getClass().getName() + "#" + this.handler.hashCode();
    }

    public boolean onConnect(INonBlockingConnection connection, SerializedTaskQueue taskQueue, Executor workerpool) throws IOException, BufferUnderflowException, MaxReadSizeExceededException {
        if (this.handlerInfo.isConnectHandler()) {
            if (this.handlerInfo.isUnsynchronized()) {
                this.performOnConnect(connection, taskQueue);
            } else if (this.getHandlerInfo().isConnectHandlerMultithreaded()) {
                taskQueue.performMultiThreaded(new PerformOnConnectTask(connection, taskQueue), workerpool);
            } else {
                taskQueue.performNonThreaded(new PerformOnConnectTask(connection, taskQueue), workerpool);
            }
        }
        return true;
    }

    private boolean performOnConnect(INonBlockingConnection connection, SerializedTaskQueue taskQueue) {
        try {
            ((IConnectHandler)this.handler).onConnect(connection);
        }
        catch (MaxReadSizeExceededException mee) {
            LOG.warning("[" + connection.getId() + "] closing connection because max readsize is reached by handling onConnect by appHandler. " + this.printHandler() + " Reason: " + mee.toString());
            this.closeSilence(connection);
        }
        catch (BufferUnderflowException bue) {
        }
        catch (IOException ioe) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + connection.getId() + "] closing connection because an error has been occured by handling onConnect by appHandler. " + this.printHandler() + " Reason: " + ioe.toString());
            }
            this.closeSilence(connection);
        }
        catch (Throwable t) {
            LOG.warning("[" + connection.getId() + "] closing connection. Error occured by performing onConnect of " + this.printHandler() + " " + t.toString());
            this.closeSilence(connection);
        }
        return false;
    }

    public boolean onData(INonBlockingConnection connection, SerializedTaskQueue taskQueue, Executor workerpool, boolean ignoreException, boolean isUnsynchronized) throws IOException, BufferUnderflowException, MaxReadSizeExceededException {
        if (this.handlerInfo.isDataHandler()) {
            if (this.handlerInfo.isUnsynchronized()) {
                this.performOnData(connection, taskQueue, ignoreException);
            } else if (this.getHandlerInfo().isDataHandlerMultithreaded()) {
                taskQueue.performMultiThreaded(new PerformOnDataTask(connection, taskQueue, ignoreException), workerpool);
            } else if (isUnsynchronized) {
                this.performOnData(connection, taskQueue, ignoreException);
            } else {
                taskQueue.performNonThreaded(new PerformOnDataTask(connection, taskQueue, ignoreException), workerpool);
            }
        } else if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("[" + connection.getId() + "] assigned handler " + this.printHandler() + " is not a data handler");
        }
        return true;
    }

    private void performOnData(INonBlockingConnection connection, SerializedTaskQueue taskQueue, boolean ignoreException) {
        block12: {
            try {
                while (connection.available() != 0 && !connection.isReceivingSuspended()) {
                    if (connection.getHandler() != this.handler) {
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine("[" + connection.getId() + "] handler " + " replaced by " + connection.getHandler() + ". stop handling data for old handler");
                        }
                        return;
                    }
                    int version = connection.getReadBufferVersion();
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("[" + connection.getId() + "] calling onData method of handler " + this.printHandler());
                    }
                    ((IDataHandler)this.handler).onData(connection);
                    if (version != connection.getReadBufferVersion()) continue;
                    return;
                }
            }
            catch (MaxReadSizeExceededException mee) {
                if (!ignoreException) {
                    LOG.warning("[" + connection.getId() + "] closing connection because max readsize is reached by handling onData by appHandler. " + this.printHandler() + " Reason: " + mee.toString());
                    this.closeSilence(connection);
                }
            }
            catch (BufferUnderflowException bue) {
            }
            catch (IOException ioe) {
                if (!ignoreException) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("[" + connection.getId() + "] closing connection because an error has been occured by handling data by appHandler. " + this.printHandler() + " Reason: " + DataConverter.toString(ioe));
                    }
                    this.closeSilence(connection);
                }
            }
            catch (Throwable t) {
                if (ignoreException) break block12;
                LOG.warning("[" + connection.getId() + "] closing connection. Error occured by performing onData of " + this.printHandler() + " " + t.toString());
                this.closeSilence(connection);
            }
        }
    }

    public boolean onDisconnect(INonBlockingConnection connection, SerializedTaskQueue taskQueue, Executor workerpool, boolean isUnsynchronized) throws IOException {
        if (this.handlerInfo.isDisconnectHandler()) {
            if (this.handlerInfo.isUnsynchronized()) {
                this.performOnDisconnect(connection, taskQueue);
            } else if (this.getHandlerInfo().isDisconnectHandlerMultithreaded()) {
                taskQueue.performMultiThreaded(new PerformOnDisconnectTask(connection, taskQueue), workerpool);
            } else if (isUnsynchronized) {
                this.performOnDisconnect(connection, taskQueue);
            } else {
                taskQueue.performNonThreaded(new PerformOnDisconnectTask(connection, taskQueue), workerpool);
            }
        }
        return true;
    }

    private void performOnDisconnect(INonBlockingConnection connection, SerializedTaskQueue taskQueue) {
        try {
            ((IDisconnectHandler)this.handler).onDisconnect(connection);
        }
        catch (MaxReadSizeExceededException mee) {
        }
        catch (BufferUnderflowException bue) {
        }
        catch (IOException ioe) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + connection.getId() + "] io exception occured while performing onDisconnect multithreaded " + this.printHandler() + " " + ioe.toString());
            }
        }
        catch (Throwable t) {
            LOG.warning("[" + connection.getId() + "] Error occured by performing onDisconnect off " + this.printHandler() + " " + t.toString());
        }
    }

    public boolean onConnectException(INonBlockingConnection connection, SerializedTaskQueue taskQueue, Executor workerpool, IOException ioe) throws IOException {
        if (this.handlerInfo.isConnectExceptionHandler()) {
            if (this.handlerInfo.isUnsynchronized()) {
                this.performOnConnectException(connection, taskQueue, ioe);
            } else if (this.getHandlerInfo().isConnectExceptionHandlerMultithreaded()) {
                taskQueue.performMultiThreaded(new PerformOnConnectExceptionTask(connection, taskQueue, ioe), workerpool);
            } else {
                taskQueue.performNonThreaded(new PerformOnConnectExceptionTask(connection, taskQueue, ioe), workerpool);
            }
        }
        return true;
    }

    private boolean performOnConnectException(INonBlockingConnection connection, SerializedTaskQueue taskQueue, IOException ioe) throws IOException {
        try {
            return ((IConnectExceptionHandler)this.handler).onConnectException(connection, ioe);
        }
        catch (RuntimeException re) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + connection.getId() + "] closing connection because an error has been occured by handling onDisconnect by appHandler. " + this.printHandler() + " Reason: " + re.toString());
            }
            this.closeSilence(connection);
            throw re;
        }
        catch (IOException e) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + connection.getId() + "] closing connection because an error has been occured by handling onDisconnect by appHandler. " + this.printHandler() + " Reason: " + ioe.toString());
            }
            this.closeSilence(connection);
            throw ioe;
        }
    }

    public boolean onIdleTimeout(INonBlockingConnection connection, SerializedTaskQueue taskQueue, Executor workerpool) throws IOException {
        if (this.handlerInfo.isIdleTimeoutHandler()) {
            if (this.handlerInfo.isUnsynchronized()) {
                this.performOnIdleTimeout(connection, taskQueue);
            } else if (this.getHandlerInfo().isIdleTimeoutHandlerMultithreaded()) {
                taskQueue.performMultiThreaded(new PerformOnIdleTimeoutTask(connection, taskQueue), workerpool);
            } else {
                taskQueue.performNonThreaded(new PerformOnIdleTimeoutTask(connection, taskQueue), workerpool);
            }
        } else {
            this.closeSilence(connection);
        }
        return true;
    }

    private void performOnIdleTimeout(INonBlockingConnection connection, SerializedTaskQueue taskQueue) {
        try {
            boolean isHandled = ((IIdleTimeoutHandler)this.handler).onIdleTimeout(connection);
            if (!isHandled) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + connection.getId() + "] closing connection because idle timeout has been occured and timeout handler returns true)");
                }
                this.closeSilence(connection);
            }
        }
        catch (MaxReadSizeExceededException mee) {
            LOG.warning("[" + connection.getId() + "] closing connection because max readsize is reached by handling onIdleTimeout by appHandler. " + this.printHandler() + " Reason: " + mee.toString());
            this.closeSilence(connection);
        }
        catch (BufferUnderflowException bue) {
        }
        catch (IOException ioe) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + connection.getId() + "] closing connection. An IO exception occured while performing onIdleTimeout multithreaded " + this.printHandler() + " " + ioe.toString());
            }
            this.closeSilence(connection);
        }
        catch (Throwable t) {
            LOG.warning("[" + connection.getId() + "] closing connection. Error occured by performing onIdleTimeout of " + this.printHandler() + " " + t.toString());
            this.closeSilence(connection);
        }
    }

    public boolean onConnectionTimeout(INonBlockingConnection connection, SerializedTaskQueue taskQueue, Executor workerpool) throws IOException {
        if (this.handlerInfo.isConnectionTimeoutHandler()) {
            if (this.handlerInfo.isUnsynchronized()) {
                this.performOnConnectionTimeout(connection, taskQueue);
            } else if (this.getHandlerInfo().isConnectionTimeoutHandlerMultithreaded()) {
                taskQueue.performMultiThreaded(new PerformOnConnectionTimeoutTask(connection, taskQueue), workerpool);
            } else {
                taskQueue.performNonThreaded(new PerformOnConnectionTimeoutTask(connection, taskQueue), workerpool);
            }
        } else {
            this.closeSilence(connection);
        }
        return true;
    }

    private void performOnConnectionTimeout(INonBlockingConnection connection, SerializedTaskQueue taskQueue) {
        try {
            boolean isHandled = ((IConnectionTimeoutHandler)this.handler).onConnectionTimeout(connection);
            if (!isHandled) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + connection.getId() + "] closing connection because connection timeout has been occured and timeout handler returns true)");
                }
                this.closeSilence(connection);
            }
        }
        catch (MaxReadSizeExceededException mee) {
            LOG.warning("[" + connection.getId() + "] closing connection because max readsize hasbeen reached by handling onConnectionTimeout by appHandler. " + this.printHandler() + " Reason: " + mee.toString());
            this.closeSilence(connection);
        }
        catch (BufferUnderflowException bue) {
        }
        catch (IOException ioe) {
            LOG.warning("[" + connection.getId() + "] closing connection because an error has been occured by handling onConnectionTimeout by appHandler. " + this.handler + " Reason: " + ioe.toString());
            this.closeSilence(connection);
        }
        catch (Throwable t) {
            LOG.warning("[" + connection.getId() + "] closing connection. Error occured by performing onConnectionTimeout of " + this.printHandler() + " " + t.toString());
            this.closeSilence(connection);
        }
    }

    public final void onInit() {
        if (this.handlerInfo.isLifeCycle()) {
            ((ILifeCycle)((Object)this.handler)).onInit();
        }
    }

    public final void onDestroy() {
        block3: {
            if (this.handlerInfo.isLifeCycle()) {
                try {
                    ((ILifeCycle)((Object)this.handler)).onDestroy();
                }
                catch (IOException ioe) {
                    if (!LOG.isLoggable(Level.FINE)) break block3;
                    LOG.fine("exception occured by destroying " + this.printHandler() + " " + ioe.toString());
                }
            }
        }
    }

    HandlerAdapter getConnectionInstance() {
        if (this.handlerInfo.isConnectionScoped()) {
            try {
                IHandler hdlCopy = (IHandler)((IConnectionScoped)((Object)this.handler)).clone();
                return new HandlerAdapter(hdlCopy, this.handlerInfo);
            }
            catch (CloneNotSupportedException cnse) {
                throw new RuntimeException(cnse.toString());
            }
        }
        return this;
    }

    private void closeSilence(INonBlockingConnection connection) {
        block2: {
            try {
                connection.close();
            }
            catch (Exception e) {
                if (!LOG.isLoggable(Level.FINE)) break block2;
                LOG.fine("error occured by closing connection " + connection + " " + e.toString());
            }
        }
    }

    @Execution(value=0)
    private static final class NullHandler
    implements IHandler {
        private NullHandler() {
        }
    }

    private final class PerformOnConnectionTimeoutTask
    implements Runnable {
        private final INonBlockingConnection connection;
        private final SerializedTaskQueue taskQueue;

        public PerformOnConnectionTimeoutTask(INonBlockingConnection connection, SerializedTaskQueue taskQueue) {
            this.connection = connection;
            this.taskQueue = taskQueue;
        }

        public void run() {
            HandlerAdapter.this.performOnConnectionTimeout(this.connection, this.taskQueue);
        }
    }

    private final class PerformOnIdleTimeoutTask
    implements Runnable {
        private final INonBlockingConnection connection;
        private final SerializedTaskQueue taskQueue;

        public PerformOnIdleTimeoutTask(INonBlockingConnection connection, SerializedTaskQueue taskQueue) {
            this.connection = connection;
            this.taskQueue = taskQueue;
        }

        public void run() {
            HandlerAdapter.this.performOnIdleTimeout(this.connection, this.taskQueue);
        }
    }

    private final class PerformOnConnectExceptionTask
    implements Runnable {
        private final INonBlockingConnection connection;
        private final SerializedTaskQueue taskQueue;
        private final IOException ioe;

        public PerformOnConnectExceptionTask(INonBlockingConnection connection, SerializedTaskQueue taskQueue, IOException ioe) {
            this.connection = connection;
            this.taskQueue = taskQueue;
            this.ioe = ioe;
        }

        public void run() {
            try {
                HandlerAdapter.this.performOnConnectException(this.connection, this.taskQueue, this.ioe);
            }
            catch (MaxReadSizeExceededException mee) {
                LOG.warning("[" + this.connection.getId() + "] closing connection because max readsize is reached by handling onConnectException by appHandler. " + HandlerAdapter.this.printHandler() + " Reason: " + mee.toString());
                HandlerAdapter.this.closeSilence(this.connection);
            }
            catch (BufferUnderflowException bue) {
            }
            catch (IOException e) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + this.connection.getId() + "] closing connection.  An io exception occured while performing onConnectException multithreaded " + HandlerAdapter.this.printHandler() + " " + e.toString());
                }
                HandlerAdapter.this.closeSilence(this.connection);
            }
            catch (Throwable t) {
                LOG.warning("[" + this.connection.getId() + "] closing connection. Error occured by performing onConnectionException of " + HandlerAdapter.this.printHandler() + " " + t.toString());
                HandlerAdapter.this.closeSilence(this.connection);
            }
        }
    }

    private final class PerformOnDisconnectTask
    implements Runnable {
        private final INonBlockingConnection connection;
        private final SerializedTaskQueue taskQueue;

        public PerformOnDisconnectTask(INonBlockingConnection connection, SerializedTaskQueue taskQueue) {
            this.connection = connection;
            this.taskQueue = taskQueue;
        }

        public void run() {
            HandlerAdapter.this.performOnDisconnect(this.connection, this.taskQueue);
        }

        public String toString() {
            return "PerformOnDisconnectTask#" + this.hashCode() + " " + this.connection.getId();
        }
    }

    private final class PerformOnDataTask
    implements Runnable {
        private final INonBlockingConnection connection;
        private final SerializedTaskQueue taskQueue;
        private final boolean ignoreException;

        public PerformOnDataTask(INonBlockingConnection connection, SerializedTaskQueue taskQueue, boolean ignoreException) {
            this.connection = connection;
            this.taskQueue = taskQueue;
            this.ignoreException = ignoreException;
        }

        public void run() {
            HandlerAdapter.this.performOnData(this.connection, this.taskQueue, this.ignoreException);
        }

        public String toString() {
            return "PerformOnDataTask#" + this.hashCode() + " " + this.connection.getId();
        }
    }

    private final class PerformOnConnectTask
    implements Runnable {
        private final INonBlockingConnection connection;
        private final SerializedTaskQueue taskQueue;

        public PerformOnConnectTask(INonBlockingConnection connection, SerializedTaskQueue taskQueue) {
            this.connection = connection;
            this.taskQueue = taskQueue;
        }

        public void run() {
            HandlerAdapter.this.performOnConnect(this.connection, this.taskQueue);
        }
    }
}

