/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.renderer;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.jopendocument.model.style.StyleStyle;
import org.jopendocument.model.style.StyleTextProperties;
import org.jopendocument.model.text.TextP;
import org.jopendocument.model.text.TextSpan;
import org.jopendocument.renderer.ODTCellTextItem;
import org.jopendocument.renderer.ODTCellTextLineItem;

public class ODTCellText {
    private List<ODTCellTextItem> items = new Vector<ODTCellTextItem>();
    private TextP textP;
    private Graphics2D g2;
    private double resizeFactor;
    private StyleStyle cellTextStyle;

    public ODTCellText(Graphics2D graphics2D, TextP textP, double d, StyleStyle styleStyle) {
        this.textP = textP;
        this.g2 = graphics2D;
        this.resizeFactor = d;
        if (styleStyle == null) {
            throw new IllegalArgumentException("Default style null");
        }
        this.cellTextStyle = styleStyle;
        this.computeItems();
    }

    public String getFullText() {
        String string = "";
        List<TextSpan> list = this.textP.getTextSpans();
        for (TextSpan textSpan : list) {
            if (textSpan.getValue() == null) continue;
            string = string + textSpan.getValue();
        }
        return string;
    }

    public boolean isEmpty() {
        List<TextSpan> list = this.textP.getTextSpans();
        for (TextSpan textSpan : list) {
            if (textSpan.getValue() == null || textSpan.getValue().length() <= 0) continue;
            return false;
        }
        return true;
    }

    public int getHeight() {
        int n = 0;
        for (ODTCellTextItem oDTCellTextItem : this.items) {
            int n2 = oDTCellTextItem.getHeight();
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    public int getWidth() {
        int n = 0;
        for (ODTCellTextItem oDTCellTextItem : this.items) {
            int n2 = oDTCellTextItem.getWidth();
            n += n2;
        }
        return n;
    }

    public void draw(int n, int n2) {
        int n3 = n;
        for (ODTCellTextItem oDTCellTextItem : this.items) {
            Font font = oDTCellTextItem.getFont();
            this.g2.setFont(font);
            this.g2.setColor(oDTCellTextItem.getColor());
            String string = oDTCellTextItem.getText();
            if (string == null) continue;
            this.g2.drawString(string, n3, n2);
            n3 += oDTCellTextItem.getWidth();
        }
    }

    private void computeItems() {
        List<TextSpan> list = this.textP.getTextSpans();
        for (TextSpan textSpan : list) {
            textSpan.setTextStyle(this.mergeStyle(this.cellTextStyle, textSpan.getTextStyle()));
            ODTCellTextItem oDTCellTextItem = new ODTCellTextItem(this.g2, textSpan.getValue(), this.resizeFactor, textSpan.getTextStyle());
            this.items.add(oDTCellTextItem);
        }
    }

    private StyleStyle mergeStyle(StyleStyle styleStyle, StyleStyle styleStyle2) {
        StyleStyle styleStyle3 = new StyleStyle();
        StyleTextProperties styleTextProperties = styleStyle.getStyleTextProperties();
        StyleTextProperties styleTextProperties2 = null;
        if (styleStyle2 != null) {
            styleTextProperties2 = styleStyle2.getStyleTextProperties();
        }
        styleStyle3.setTextProperties(this.mergeTextProperties(styleTextProperties, styleTextProperties2));
        return styleStyle3;
    }

    private StyleTextProperties mergeTextProperties(StyleTextProperties styleTextProperties, StyleTextProperties styleTextProperties2) {
        StyleTextProperties styleTextProperties3 = new StyleTextProperties();
        String string = null;
        if (styleTextProperties2 != null) {
            string = styleTextProperties2.getFontName();
        }
        if (string == null && styleTextProperties != null) {
            string = styleTextProperties.getFontName();
        }
        if (string == null) {
            System.err.println("Assuming default font:Arial");
            string = "Arial";
        }
        String string2 = null;
        if (styleTextProperties2 != null) {
            string2 = styleTextProperties2.getFontSize();
        }
        if (string2 == null && styleTextProperties != null) {
            string2 = styleTextProperties.getFontSize();
        }
        if (string2 == null) {
            string2 = "11pt";
        }
        String string3 = null;
        if (styleTextProperties2 != null) {
            string3 = styleTextProperties2.getFontWeight();
        }
        if (string3 == null && styleTextProperties != null) {
            string3 = styleTextProperties.getFontWeight();
        }
        if (string3 == null) {
            string3 = "normal";
        }
        Color color = null;
        if (styleTextProperties2 != null) {
            color = styleTextProperties2.getColor();
        }
        if (color == null && styleTextProperties != null) {
            color = styleTextProperties.getColor();
        }
        if (color == null) {
            color = Color.BLACK;
        }
        styleTextProperties3.setFontName(string);
        styleTextProperties3.setFontSize(string2);
        styleTextProperties3.setFontWeight(string3);
        styleTextProperties3.setColor(color);
        return styleTextProperties3;
    }

    /*
     * WARNING - void declaration
     */
    public void drawJustified(int n, int n2, String string, int n3, int n4) {
        int n5;
        int n6;
        String[] stringArray;
        int n7 = n4 - 2 * n3;
        ArrayList<ODTCellTextItem> arrayList = new ArrayList<ODTCellTextItem>();
        List<TextSpan> list = this.textP.getTextSpans();
        for (TextSpan object2 : list) {
            object2.setTextStyle(this.mergeStyle(this.cellTextStyle, object2.getTextStyle()));
            stringArray = object2.getCutedValues();
            for (n6 = 0; n6 < stringArray.length; ++n6) {
                String string2 = stringArray[n6].trim();
                ODTCellTextItem oDTCellTextItem = new ODTCellTextItem(this.g2, string2, this.resizeFactor, object2.getTextStyle());
                arrayList.add(oDTCellTextItem);
            }
        }
        int n8 = 0;
        ODTCellTextLineItem oDTCellTextLineItem = new ODTCellTextLineItem();
        stringArray = new ArrayList();
        stringArray.add(oDTCellTextLineItem);
        n6 = 0;
        for (ODTCellTextItem oDTCellTextItem : arrayList) {
            void var10_13;
            int n9;
            n5 = oDTCellTextItem.getWidthWithSpace();
            if ((n8 += n5) > n7) {
                ODTCellTextLineItem oDTCellTextLineItem2 = new ODTCellTextLineItem();
                n6 = 0;
                n8 = n5;
                stringArray.add(oDTCellTextLineItem2);
            }
            if ((n9 = oDTCellTextItem.getHeight()) > n6) {
                n6 = n9;
            }
            var10_13.addItem(oDTCellTextItem);
        }
        int n10 = n + n3;
        int n11 = n2;
        for (n5 = 0; n5 < stringArray.size(); ++n5) {
            ODTCellTextLineItem oDTCellTextLineItem3 = (ODTCellTextLineItem)stringArray.get(n5);
            int n12 = 0;
            int n13 = n7 - oDTCellTextLineItem3.getTotalWidthWithoutSpace();
            if (oDTCellTextLineItem3.getSize() > 1 && n13 > 0 && n5 < stringArray.size() - 1) {
                n12 = n13 / (oDTCellTextLineItem3.getSize() - 1);
            }
            n11 += oDTCellTextLineItem3.getHeight();
            n11 = (int)((double)n11 + 1440.0 / this.resizeFactor);
            for (ODTCellTextItem oDTCellTextItem : oDTCellTextLineItem3.getItems()) {
                Font font = oDTCellTextItem.getFont();
                this.g2.setFont(font);
                this.g2.setColor(oDTCellTextItem.getColor());
                String string3 = oDTCellTextItem.getText();
                if (n12 == 0) {
                    string3 = string3 + " ";
                    oDTCellTextItem.setText(string3);
                }
                if (string3 == null) continue;
                this.g2.drawString(string3, n10, n11);
                n10 += oDTCellTextItem.getWidth() + n12;
            }
            n10 = n + n3;
        }
    }
}

