/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio;

import com.hazelcast.nio.AbstractSelectionHandler;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.SocketPacketWriter;
import com.hazelcast.nio.SocketWritable;
import com.hazelcast.nio.SocketWriter;
import com.hazelcast.nio.ascii.SocketTextWriter;
import com.hazelcast.util.Clock;
import java.nio.ByteBuffer;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;

public final class WriteHandler
extends AbstractSelectionHandler
implements Runnable {
    private final Queue<SocketWritable> writeQueue = new ConcurrentLinkedQueue<SocketWritable>(){
        final AtomicInteger size = new AtomicInteger();

        @Override
        public boolean offer(SocketWritable socketWritable) {
            if (super.offer(socketWritable)) {
                this.size.incrementAndGet();
                return true;
            }
            return false;
        }

        @Override
        public SocketWritable poll() {
            SocketWritable socketWritable = (SocketWritable)super.poll();
            if (socketWritable != null) {
                this.size.decrementAndGet();
            }
            return socketWritable;
        }

        @Override
        public int size() {
            return this.size.get();
        }
    };
    private final AtomicBoolean informSelector = new AtomicBoolean(true);
    private final ByteBuffer socketBB;
    private boolean ready = false;
    private volatile SocketWritable lastWritable = null;
    private volatile SocketWriter socketWriter = null;
    volatile long lastRegistration = 0L;
    volatile long lastHandle = 0L;
    final long fiveMillis = TimeUnit.MILLISECONDS.toNanos(5L);

    WriteHandler(Connection connection) {
        super(connection, connection.getInOutSelector());
        this.socketBB = ByteBuffer.allocate(this.connectionManager.SOCKET_SEND_BUFFER_SIZE);
    }

    public void setProtocol(String protocol) {
        if (this.socketWriter == null) {
            if ("HZC".equals(protocol)) {
                this.socketWriter = new SocketPacketWriter(this.connection);
                this.socketBB.put("HZC".getBytes());
                this.inOutSelector.addTask(this);
            } else {
                this.socketWriter = new SocketTextWriter(this.connection);
            }
        }
    }

    public SocketWriter getSocketWriter() {
        return this.socketWriter;
    }

    public void enqueueSocketWritable(SocketWritable socketWritable) {
        socketWritable.onEnqueue();
        this.writeQueue.offer(socketWritable);
        if (this.informSelector.compareAndSet(true, false)) {
            this.inOutSelector.addTask(this);
            this.inOutSelector.selector.wakeup();
        }
    }

    SocketWritable poll() {
        return this.writeQueue.poll();
    }

    /*
     * Exception decompiling
     */
    @Override
    public void handle() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void run() {
        this.informSelector.set(true);
        if (this.ready) {
            this.handle();
        } else {
            this.registerWrite();
        }
        this.ready = false;
    }

    private void registerWrite() {
        this.lastRegistration = Clock.currentTimeMillis();
        this.registerOp(this.inOutSelector.selector, 4);
    }

    private void flush(int waitMillis) {
        long remaining = waitMillis;
        while (this.size() > 0 && remaining > 0L) {
            long start = Clock.currentTimeMillis();
            LockSupport.parkNanos(this.fiveMillis);
            remaining -= Clock.currentTimeMillis() - start;
        }
    }

    @Override
    public void shutdown() {
        this.writeQueue.clear();
    }

    public int size() {
        return this.writeQueue.size();
    }
}

