/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.AccessControlException;
import java.util.Map;
import java.util.Properties;
import twitter4j.Version;

public class Configuration {
    private static Properties defaultProperty;
    private static boolean DALVIK;

    static {
        Configuration.init();
    }

    static void init() {
        defaultProperty = new Properties();
        defaultProperty.setProperty("twitter4j.debug", "false");
        defaultProperty.setProperty("twitter4j.source", "Twitter4J");
        defaultProperty.setProperty("twitter4j.clientURL", "http://yusuke.homeip.net/twitter4j/en/twitter4j-{twitter4j.clientVersion}.xml");
        defaultProperty.setProperty("twitter4j.http.userAgent", "twitter4j http://yusuke.homeip.net/twitter4j/ /{twitter4j.clientVersion}");
        defaultProperty.setProperty("twitter4j.http.useSSL", "false");
        defaultProperty.setProperty("twitter4j.http.proxyHost.fallback", "http.proxyHost");
        defaultProperty.setProperty("twitter4j.http.proxyPort.fallback", "http.proxyPort");
        defaultProperty.setProperty("twitter4j.http.connectionTimeout", "20000");
        defaultProperty.setProperty("twitter4j.http.readTimeout", "120000");
        defaultProperty.setProperty("twitter4j.http.retryCount", "3");
        defaultProperty.setProperty("twitter4j.http.retryIntervalSecs", "10");
        defaultProperty.setProperty("twitter4j.async.numThreads", "1");
        defaultProperty.setProperty("twitter4j.clientVersion", Version.getVersion());
        try {
            Class.forName("dalvik.system.VMRuntime");
            defaultProperty.setProperty("twitter4j.dalvik", "true");
        }
        catch (ClassNotFoundException cnfe) {
            defaultProperty.setProperty("twitter4j.dalvik", "false");
        }
        DALVIK = Configuration.getBoolean("twitter4j.dalvik");
        String t4jProps = "twitter4j.properties";
        boolean loaded = Configuration.loadProperties(defaultProperty, "." + File.separatorChar + t4jProps) || Configuration.loadProperties(defaultProperty, Configuration.class.getResourceAsStream("/WEB-INF/" + t4jProps)) || Configuration.loadProperties(defaultProperty, Configuration.class.getResourceAsStream("/" + t4jProps));
    }

    private static boolean loadProperties(Properties props, String path) {
        try {
            File file = new File(path);
            if (file.exists() && file.isFile()) {
                props.load(new FileInputStream(file));
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private static boolean loadProperties(Properties props, InputStream is) {
        try {
            props.load(is);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setProperty(String name, String value) {
        Properties properties = defaultProperty;
        synchronized (properties) {
            defaultProperty.put(name, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setProperties(Properties properties) {
        Properties properties2 = defaultProperty;
        synchronized (properties2) {
            defaultProperty.putAll((Map<?, ?>)properties);
        }
    }

    public static boolean isDalvik() {
        return DALVIK;
    }

    public static boolean useSSL() {
        return Configuration.getBoolean("twitter4j.http.useSSL");
    }

    public static String getScheme() {
        return Configuration.useSSL() ? "https://" : "http://";
    }

    public static String getCilentVersion() {
        return Configuration.getProperty("twitter4j.clientVersion");
    }

    public static String getCilentVersion(String clientVersion) {
        return Configuration.getProperty("twitter4j.clientVersion", clientVersion);
    }

    public static String getSource() {
        return Configuration.getProperty("twitter4j.source");
    }

    public static String getSource(String source) {
        return Configuration.getProperty("twitter4j.source", source);
    }

    public static String getProxyHost() {
        return Configuration.getProperty("twitter4j.http.proxyHost");
    }

    public static String getProxyHost(String proxyHost) {
        return Configuration.getProperty("twitter4j.http.proxyHost", proxyHost);
    }

    public static String getProxyUser() {
        return Configuration.getProperty("twitter4j.http.proxyUser");
    }

    public static String getProxyUser(String user) {
        return Configuration.getProperty("twitter4j.http.proxyUser", user);
    }

    public static String getClientURL() {
        return Configuration.getProperty("twitter4j.clientURL");
    }

    public static String getClientURL(String clientURL) {
        return Configuration.getProperty("twitter4j.clientURL", clientURL);
    }

    public static String getProxyPassword() {
        return Configuration.getProperty("twitter4j.http.proxyPassword");
    }

    public static String getProxyPassword(String password) {
        return Configuration.getProperty("twitter4j.http.proxyPassword", password);
    }

    public static int getProxyPort() {
        return Configuration.getIntProperty("twitter4j.http.proxyPort");
    }

    public static int getProxyPort(int port) {
        return Configuration.getIntProperty("twitter4j.http.proxyPort", port);
    }

    public static int getConnectionTimeout() {
        return Configuration.getIntProperty("twitter4j.http.connectionTimeout");
    }

    public static int getConnectionTimeout(int connectionTimeout) {
        return Configuration.getIntProperty("twitter4j.http.connectionTimeout", connectionTimeout);
    }

    public static int getReadTimeout() {
        return Configuration.getIntProperty("twitter4j.http.readTimeout");
    }

    public static int getReadTimeout(int readTimeout) {
        return Configuration.getIntProperty("twitter4j.http.readTimeout", readTimeout);
    }

    public static int getRetryCount() {
        return Configuration.getIntProperty("twitter4j.http.retryCount");
    }

    public static int getRetryCount(int retryCount) {
        return Configuration.getIntProperty("twitter4j.http.retryCount", retryCount);
    }

    public static int getRetryIntervalSecs() {
        return Configuration.getIntProperty("twitter4j.http.retryIntervalSecs");
    }

    public static int getRetryIntervalSecs(int retryIntervalSecs) {
        return Configuration.getIntProperty("twitter4j.http.retryIntervalSecs", retryIntervalSecs);
    }

    public static String getUser() {
        return Configuration.getProperty("twitter4j.user");
    }

    public static String getUser(String userId) {
        return Configuration.getProperty("twitter4j.user", userId);
    }

    public static String getPassword() {
        return Configuration.getProperty("twitter4j.password");
    }

    public static String getPassword(String password) {
        return Configuration.getProperty("twitter4j.password", password);
    }

    public static String getUserAgent() {
        return Configuration.getProperty("twitter4j.http.userAgent");
    }

    public static String getUserAgent(String userAgent) {
        return Configuration.getProperty("twitter4j.http.userAgent", userAgent);
    }

    public static String getOAuthConsumerKey() {
        return Configuration.getProperty("twitter4j.oauth.consumerKey");
    }

    public static String getOAuthConsumerKey(String consumerKey) {
        return Configuration.getProperty("twitter4j.oauth.consumerKey", consumerKey);
    }

    public static String getOAuthConsumerSecret() {
        return Configuration.getProperty("twitter4j.oauth.consumerSecret");
    }

    public static String getOAuthConsumerSecret(String consumerSecret) {
        return Configuration.getProperty("twitter4j.oauth.consumerSecret", consumerSecret);
    }

    public static boolean getBoolean(String name) {
        String value = Configuration.getProperty(name);
        return Boolean.valueOf(value);
    }

    public static int getIntProperty(String name) {
        String value = Configuration.getProperty(name);
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }

    public static int getIntProperty(String name, int fallbackValue) {
        String value = Configuration.getProperty(name, String.valueOf(fallbackValue));
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }

    public static long getLongProperty(String name) {
        String value = Configuration.getProperty(name);
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException nfe) {
            return -1L;
        }
    }

    public static String getProperty(String name) {
        return Configuration.getProperty(name, null);
    }

    public static String getProperty(String name, String fallbackValue) {
        String value;
        try {
            String fallback;
            value = System.getProperty(name, fallbackValue);
            if (value == null) {
                value = defaultProperty.getProperty(name);
            }
            if (value == null && (fallback = defaultProperty.getProperty(String.valueOf(name) + ".fallback")) != null) {
                value = System.getProperty(fallback);
            }
        }
        catch (AccessControlException ace) {
            value = fallbackValue;
        }
        return Configuration.replace(value);
    }

    private static String replace(String value) {
        String name;
        int closeBrace;
        if (value == null) {
            return value;
        }
        String newValue = value;
        int openBrace = 0;
        if (-1 != (openBrace = value.indexOf("{", openBrace)) && (closeBrace = value.indexOf("}", openBrace)) > openBrace + 1 && (name = value.substring(openBrace + 1, closeBrace)).length() > 0) {
            newValue = String.valueOf(value.substring(0, openBrace)) + Configuration.getProperty(name) + value.substring(closeBrace + 1);
        }
        if (newValue.equals(value)) {
            return value;
        }
        return Configuration.replace(newValue);
    }

    public static int getNumberOfAsyncThreads() {
        return Configuration.getIntProperty("twitter4j.async.numThreads");
    }

    public static boolean getDebug() {
        return Configuration.getBoolean("twitter4j.debug");
    }
}

