/*
 * Copyright (c) 2008-2012, Hazel Bilisim Ltd. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.hazelcast.monitor;

public interface LocalSemaphoreOperationStats extends LocalInstanceOperationStats {

    /**
     * Returns the total number of acquire operations.
     *
     * @return number of acquire operations
     */
    public long getNumberOfAcquireOps();

    /**
     * Returns the total number of non-acquire operations.
     *
     * @return number of non-acquire operations
     */
    public long getNumberOfNonAcquireOps();

    /**
     * Returns the total latency of put acquire in this period.
     * </p>To get the average latency, divide by the number of
     * acquire operations.
     *
     * @return total latency of all acquire operations
     */
    public long getTotalAcquireLatency();

    /**
     * Returns the total latency of get operations in this period.
     * </p>To get the average latency, divide by the number of
     * non-acquire operations.
     *
     * @return total latency of all non-acquire operations
     */
    public long getTotalNonAcquireLatency();

    /**
     * Returns the total number of acquires operations that were
     * rejected.
     *
     * @return number of acquire operations that were rejected
     */
    public long getNumberOfRejectedAcquires();

    /**
     * Returns the number of permits acquired.
     *
     * @return number of permits acquired
     */
    public long getNumberOfPermitsAcquired();

    /**
     * Returns the number of permits released.
     *
     * @return number of permits released
     */
    public long getNumberOfPermitsReleased();

    /**
     * Returns the number of permits attached.
     *
     * @return number of permits attached
     */
    public long getNumberOfAttachedPermits();

    /**
     * Returns the number of permits detached.
     *
     * @return number of permits detached
     */
    public long getNumberOfDetachedPermits();
}
