/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.console;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.EnumSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.javasimon.Manager;
import org.javasimon.SimonManager;
import org.javasimon.console.SimonConsolePluginManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionContext {
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private String path;
    private Manager manager = SimonManager.manager();
    private SimonConsolePluginManager pluginManager;

    public ActionContext(HttpServletRequest request, HttpServletResponse response, String path) {
        this.request = request;
        this.response = response;
        this.path = path;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setContentType(String contentType) {
        this.getResponse().setContentType(contentType);
    }

    public OutputStream getOutputStream() throws IOException {
        return this.getResponse().getOutputStream();
    }

    public PrintWriter getWriter() throws IOException {
        return this.getResponse().getWriter();
    }

    public Manager getManager() {
        return this.manager;
    }

    public void setManager(Manager manager) {
        this.manager = manager;
    }

    protected String getParameter(String name) {
        return this.getRequest().getParameter(name);
    }

    protected String[] getParameters(String name) {
        return this.getRequest().getParameterValues(name);
    }

    private static String blankToNull(String value) {
        if (value != null && (value = value.trim()).equals("")) {
            value = null;
        }
        return value;
    }

    private static <T> T defaultValue(T value, T defaultValue) {
        return value == null ? defaultValue : value;
    }

    public String getParameterAsString(String name, String defaultValue) {
        return ActionContext.defaultValue(ActionContext.blankToNull(this.getParameter(name)), defaultValue);
    }

    private static Boolean stringToBoolean(String value) {
        String s = ActionContext.blankToNull(value);
        return s == null ? null : Boolean.valueOf(s);
    }

    public boolean getParameterAsBoolean(String name, Boolean defaultValue) {
        return ActionContext.defaultValue(ActionContext.stringToBoolean(this.getParameter(name)), defaultValue);
    }

    private static <T extends Enum<T>> T stringToEnum(String value, Class<T> type) {
        String s = ActionContext.blankToNull(value);
        return value == null ? null : (T)Enum.valueOf(type, s.toUpperCase());
    }

    public <T extends Enum<T>> T getParameterAsEnum(String name, Class<T> type, T defaultValue) {
        return (T)((Enum)ActionContext.defaultValue(ActionContext.stringToEnum(this.getParameter(name), type), defaultValue));
    }

    public <T extends Enum<T>> EnumSet<T> getParametersAsEnums(String name, Class<T> type, EnumSet<T> defaultValue) {
        String[] enumNames = this.getParameters(name);
        if (enumNames == null) {
            return defaultValue;
        }
        ArrayList<T> enums = new ArrayList<T>();
        for (String enumName : enumNames) {
            T enumValue = ActionContext.stringToEnum(ActionContext.blankToNull(enumName), type);
            if (enumValue == null) continue;
            enums.add(enumValue);
        }
        return enums.isEmpty() ? defaultValue : EnumSet.copyOf(enums);
    }

    public SimonConsolePluginManager getPluginManager() {
        return this.pluginManager;
    }

    public void setPluginManager(SimonConsolePluginManager pluginManager) {
        this.pluginManager = pluginManager;
    }
}

