/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xwpf.usermodel;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.poi.POIXMLDocumentPart;
import org.apache.poi.POIXMLException;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.xwpf.usermodel.XWPFLatentStyles;
import org.apache.poi.xwpf.usermodel.XWPFStyle;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTDocDefaults;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTFonts;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTLanguage;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRPrDefault;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTStyle;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTStyles;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.StylesDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XWPFStyles
extends POIXMLDocumentPart {
    private List<XWPFStyle> listStyle = new ArrayList<XWPFStyle>();
    private CTStyles ctStyles;
    XWPFLatentStyles latentStyles;

    public XWPFStyles(PackagePart part, PackageRelationship rel) throws IOException, OpenXML4JException {
        super(part, rel);
    }

    public XWPFStyles() {
    }

    @Override
    protected void onDocumentRead() throws IOException {
        try {
            InputStream is = this.getPackagePart().getInputStream();
            StylesDocument stylesDoc = StylesDocument.Factory.parse(is);
            this.ctStyles = stylesDoc.getStyles();
            this.latentStyles = new XWPFLatentStyles(this.ctStyles.getLatentStyles(), this);
        }
        catch (XmlException e) {
            throw new POIXMLException();
        }
        for (CTStyle style : this.ctStyles.getStyleList()) {
            this.listStyle.add(new XWPFStyle(style, this));
        }
    }

    @Override
    protected void commit() throws IOException {
        XmlOptions xmlOptions = new XmlOptions(DEFAULT_XML_OPTIONS);
        xmlOptions.setSaveSyntheticDocumentElement(new QName(CTStyles.type.getName().getNamespaceURI(), "styles"));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("http://schemas.openxmlformats.org/officeDocument/2006/relationships", "r");
        map.put("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "w");
        xmlOptions.setSaveSuggestedPrefixes(map);
        PackagePart part = this.getPackagePart();
        OutputStream out = part.getOutputStream();
        this.ctStyles.save(out, xmlOptions);
        out.close();
    }

    public void setStyles(CTStyles styles) {
        this.ctStyles = styles;
    }

    public boolean styleExist(String styleID) {
        for (XWPFStyle style : this.listStyle) {
            if (!style.getStyleId().equals(styleID)) continue;
            return true;
        }
        return false;
    }

    public void addStyle(XWPFStyle style) {
        this.listStyle.add(style);
        this.ctStyles.addNewStyle();
        int pos = this.ctStyles.getStyleList().size() - 1;
        this.ctStyles.setStyleArray(pos, style.getCTStyle());
    }

    public XWPFStyle getStyle(String styleID) {
        for (XWPFStyle style : this.listStyle) {
            if (!style.getStyleId().equals(styleID)) continue;
            return style;
        }
        return null;
    }

    public List<XWPFStyle> getUsedStyleList(XWPFStyle style) {
        ArrayList<XWPFStyle> usedStyleList = new ArrayList<XWPFStyle>();
        usedStyleList.add(style);
        return this.getUsedStyleList(style, usedStyleList);
    }

    private List<XWPFStyle> getUsedStyleList(XWPFStyle style, List<XWPFStyle> usedStyleList) {
        String nextStyleID;
        XWPFStyle nextStyle;
        String linkStyleID;
        XWPFStyle linkStyle;
        String basisStyleID = style.getBasisStyleID();
        XWPFStyle basisStyle = this.getStyle(basisStyleID);
        if (basisStyle != null && !usedStyleList.contains(basisStyle)) {
            usedStyleList.add(basisStyle);
            this.getUsedStyleList(basisStyle, usedStyleList);
        }
        if ((linkStyle = this.getStyle(linkStyleID = style.getLinkStyleID())) != null && !usedStyleList.contains(linkStyle)) {
            usedStyleList.add(linkStyle);
            this.getUsedStyleList(linkStyle, usedStyleList);
        }
        if ((nextStyle = this.getStyle(nextStyleID = style.getNextStyleID())) != null && !usedStyleList.contains(nextStyle)) {
            usedStyleList.add(linkStyle);
            this.getUsedStyleList(linkStyle, usedStyleList);
        }
        return usedStyleList;
    }

    public void setSpellingLanguage(String strSpellingLanguage) {
        CTRPrDefault RPrDefault;
        CTDocDefaults docDefaults = null;
        CTRPr runProps = null;
        CTLanguage lang = null;
        if (this.ctStyles.isSetDocDefaults() && (docDefaults = this.ctStyles.getDocDefaults()).isSetRPrDefault() && (RPrDefault = docDefaults.getRPrDefault()).isSetRPr() && (runProps = RPrDefault.getRPr()).isSetLang()) {
            lang = runProps.getLang();
        }
        if (docDefaults == null) {
            docDefaults = this.ctStyles.addNewDocDefaults();
        }
        if (runProps == null) {
            runProps = docDefaults.addNewRPrDefault().addNewRPr();
        }
        if (lang == null) {
            lang = runProps.addNewLang();
        }
        lang.setVal((Object)strSpellingLanguage);
        lang.setBidi((Object)strSpellingLanguage);
    }

    public void setEastAsia(String strEastAsia) {
        CTRPrDefault RPrDefault;
        CTDocDefaults docDefaults = null;
        CTRPr runProps = null;
        CTLanguage lang = null;
        if (this.ctStyles.isSetDocDefaults() && (docDefaults = this.ctStyles.getDocDefaults()).isSetRPrDefault() && (RPrDefault = docDefaults.getRPrDefault()).isSetRPr() && (runProps = RPrDefault.getRPr()).isSetLang()) {
            lang = runProps.getLang();
        }
        if (docDefaults == null) {
            docDefaults = this.ctStyles.addNewDocDefaults();
        }
        if (runProps == null) {
            runProps = docDefaults.addNewRPrDefault().addNewRPr();
        }
        if (lang == null) {
            lang = runProps.addNewLang();
        }
        lang.setEastAsia((Object)strEastAsia);
    }

    public void setDefaultFonts(CTFonts fonts) {
        CTRPrDefault RPrDefault;
        CTDocDefaults docDefaults = null;
        CTRPr runProps = null;
        if (this.ctStyles.isSetDocDefaults() && (docDefaults = this.ctStyles.getDocDefaults()).isSetRPrDefault() && (RPrDefault = docDefaults.getRPrDefault()).isSetRPr()) {
            runProps = RPrDefault.getRPr();
        }
        if (docDefaults == null) {
            docDefaults = this.ctStyles.addNewDocDefaults();
        }
        if (runProps == null) {
            runProps = docDefaults.addNewRPrDefault().addNewRPr();
        }
        runProps.setRFonts(fonts);
    }

    public XWPFLatentStyles getLatentStyles() {
        return this.latentStyles;
    }

    public XWPFStyle getStyleWithSameName(XWPFStyle style) {
        for (XWPFStyle ownStyle : this.listStyle) {
            if (!ownStyle.hasSameName(style)) continue;
            return ownStyle;
        }
        return null;
    }
}

