/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.callback;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.javasimon.Counter;
import org.javasimon.CounterSample;
import org.javasimon.Simon;
import org.javasimon.Split;
import org.javasimon.Stopwatch;
import org.javasimon.StopwatchSample;
import org.javasimon.callback.Callback;
import org.javasimon.callback.CompositeCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CompositeCallbackImpl
implements CompositeCallback {
    private List<Callback> callbacks = new CopyOnWriteArrayList<Callback>();
    private boolean initialized;

    @Override
    public List<Callback> callbacks() {
        return this.callbacks;
    }

    @Override
    public void addCallback(Callback callback) {
        if (this.initialized) {
            callback.initialize();
        }
        this.callbacks.add(callback);
    }

    @Override
    public void removeCallback(Callback callback) {
        this.callbacks.remove(callback);
        if (this.initialized) {
            callback.cleanup();
        }
    }

    @Override
    public void removeAllCallbacks() {
        for (Callback callback : this.callbacks) {
            this.removeCallback(callback);
        }
    }

    @Override
    public void initialize() {
        this.initialized = true;
        for (Callback callback : this.callbacks) {
            try {
                callback.initialize();
            }
            catch (Exception e) {
                this.onManagerWarning("Callback initialization error", e);
            }
        }
    }

    @Override
    public void cleanup() {
        this.initialized = false;
        for (Callback callback : this.callbacks) {
            try {
                callback.cleanup();
            }
            catch (Exception e) {
                this.onManagerWarning("Callback cleanup error", e);
            }
        }
    }

    @Override
    public void onSimonReset(Simon simon) {
        for (Callback callback : this.callbacks) {
            callback.onSimonReset(simon);
        }
    }

    @Override
    public void onStopwatchAdd(Stopwatch stopwatch, long ns, StopwatchSample sample) {
        for (Callback callback : this.callbacks) {
            callback.onStopwatchAdd(stopwatch, ns, sample);
        }
    }

    @Override
    public void onStopwatchAdd(Stopwatch stopwatch, Split split, StopwatchSample sample) {
        for (Callback callback : this.callbacks) {
            callback.onStopwatchAdd(stopwatch, split, sample);
        }
    }

    @Override
    public void onStopwatchStart(Split split) {
        for (Callback callback : this.callbacks) {
            callback.onStopwatchStart(split);
        }
    }

    @Override
    public void onStopwatchStop(Split split, StopwatchSample sample) {
        for (Callback callback : this.callbacks) {
            callback.onStopwatchStop(split, sample);
        }
    }

    @Override
    public void onCounterDecrease(Counter counter, long dec, CounterSample sample) {
        for (Callback callback : this.callbacks) {
            callback.onCounterDecrease(counter, dec, sample);
        }
    }

    @Override
    public void onCounterIncrease(Counter counter, long inc, CounterSample sample) {
        for (Callback callback : this.callbacks) {
            callback.onCounterIncrease(counter, inc, sample);
        }
    }

    @Override
    public void onCounterSet(Counter counter, long val, CounterSample sample) {
        for (Callback callback : this.callbacks) {
            callback.onCounterSet(counter, val, sample);
        }
    }

    @Override
    public void onSimonCreated(Simon simon) {
        for (Callback callback : this.callbacks) {
            callback.onSimonCreated(simon);
        }
    }

    @Override
    public void onSimonDestroyed(Simon simon) {
        for (Callback callback : this.callbacks) {
            callback.onSimonDestroyed(simon);
        }
    }

    @Override
    public void onManagerClear() {
        for (Callback callback : this.callbacks) {
            callback.onManagerClear();
        }
    }

    @Override
    public void onManagerMessage(String message) {
        for (Callback callback : this.callbacks) {
            callback.onManagerMessage(message);
        }
    }

    @Override
    public void onManagerWarning(String warning, Exception cause) {
        for (Callback callback : this.callbacks) {
            callback.onManagerWarning(warning, cause);
        }
    }
}

